import config from './config.js'
import { getUser} from "./ctx.js"

//Post方式提交信息
export function post(url, data, options) {
	const userInfo = getUser();
	const header = {
		"Content-Type": "application/json",
		// "appId": config.appId,
		// "appSecret": config.appSecret
	};
	if (userInfo && userInfo.token) header["zy_token"] = userInfo.token;
	
	const {
		timeout
	} = options || {};
	return new Promise((resolve, reject) => {
		uni.request({
			url: config.url + url,
			method: "POST",
			header,
			data,
			sslVerify: false,
			timeout,
			success(res) {
				if (res.statusCode == 200) {
					const r = res.data
					if (r.code > 0){
						r.code == 2 ? resolve(r) :resolve(r.data)
					}else if(r.code === -1000){
						uni.showModal({
						  title:'温馨提示',
						  content:'token失效，即将返回个人中心',
						  showCancel: false,
						  success: (res) => {
				            uni.reLaunch({
				                url: '/pages/home/homeIndex'
				            })
						  }
						})
					}else{
						/* tsk/pack/page为分页接口，没有code传回 */
						if(url==='/tsk/pack/page'){
							resolve(r)
						}else{
							reject(r)
						}
					}
				} else reject({
					code: -500,
					msg: JSON.stringify(res)
				})
			},
			fail(err) {
				reject({
					code: -500,
					msg: JSON.stringify(err)
				});
			}
		})
	})
}

// Get方式提交
export function get(url, data) {
	const userInfo = getUser();
	const header = {
		"Content-Type": "application/json",
		// "appId": config.appId,
		// "appSecret": config.appSecret
	};
	if (userInfo && userInfo.token) header["zy_token"] = userInfo.token;
	return new Promise((resolve, reject) => {
		uni.request({
			url: config.url + url,
			method: "POST",
			header,
			data,
			sslVerify: false,
			success(res) {
				if (res.statusCode == 200) {
					const r = res.data
					if (r.code > 0){
						resolve(r.data)
					}else if(r.code === -1000){
						uni.showModal({
						  title:'温馨提示',
						  content:'token失效，即将返回个人中心',
						  showCancel: false,
						  success: (res) => {
				            uni.reLaunch({
				                url: '/pages/home/homeIndex'
				            })
						  }
						})
					}else{
						reject(r)
					}
				} else reject({
					code: -500,
					msg: JSON.stringify(res)
				})
			},
			fail(err) {
				reject({
					code: -500,
					msg: JSON.stringify(err)
				});
			}
		})
	})
}

//Post方式提交信息
export function filePost(url, data, options) {
	const userInfo = getUser();
	const header = {
		"Content-Type": "application/json",
		// "appId": config.appId,
		// "appSecret": config.appSecret
	};
	if (userInfo && userInfo.token) header["zy_token"] = userInfo.token;
	
	const {
		timeout
	} = options || {};
	return new Promise((resolve, reject) => {
		uni.request({
			url: config.url.replace(/\/papi$/,'/file-api') + url,
			method: "POST",
			header,
			data,
			sslVerify: false,
			timeout,
			success(res) {
				if (res.statusCode == 200) {
					const r = res.data
					if (r.code > 0){
						r.code == 2 ? resolve(r) :resolve(r.data)
					}else if(r.code === -1000){
						uni.showModal({
						  title:'温馨提示',
						  content:'token失效，即将返回个人中心',
						  showCancel: false,
						  success: (res) => {
				            uni.reLaunch({
				                url: '/pages/home/homeIndex'
				            })
						  }
						})
					}else{
						/* tsk/pack/page为分页接口，没有code传回 */
						if(url==='/tsk/pack/page'){
							resolve(r)
						}else{
							reject(r)
						}
					}
				} else reject({
					code: -500,
					msg: JSON.stringify(res)
				})
			},
			fail(err) {
				reject({
					code: -500,
					msg: JSON.stringify(err)
				});
			}
		})
	})
}

// Post方式提交文件
export function uploadFile(url, file, data, options) {
	const userInfo = getUser();
	const header = {}
	if (userInfo && userInfo.token) header["zy_token"] = userInfo.token;
	const {
		timeout
	} = options || {};
	//null值不提交
	const formData = {};
	if (data) {
		for (let k in data) {
			const v = data[k];
			if (v == null || v == '') continue;
			formData[k] = v;
		}
	}
	return new Promise((resolve, reject) => {
		uni.uploadFile({
			url: config.url.replace(/\/papi$/,'/file-api') + url,
			header,
			filePath: file,
			name: 'file',
			formData: formData,
			timeout,
			success(res) {
				if (res.statusCode == 200) {
					const r = typeof(res.data) == 'string' ? JSON.parse(res.data) : res.data;
					if (r.code > 0){
						resolve(r.data)
					}else if(r.code === -1000){
						uni.showModal({
						  title:'温馨提示',
						  content:'token失效，即将返回个人中心',
						  showCancel: false,
						  success: (res) => {
				            uni.reLaunch({
				                url: '/pages/home/homeIndex'
				            })
						  }
						})
					}else{
						reject(r)
					}
				} else reject({
					code: -500,
					msg: JSON.stringify(res)
				})
			},
			fail(err) {
				console.log(err)
				reject({
					code: -500,
					msg: JSON.stringify(err)
				});
			}
		})
	})
}

//识别航材
export function recogineseMat(path) {
	const userInfo = getUser();
	const header = { 'zy_token': userInfo.token };
	return new Promise((resolve, reject) => {
		uni.uploadFile({
			url: config.url + '/tool/recognise/pn',
			filePath: path,
			name: 'file',
			header,
			timeout: 120000,
			success:(res)=> {
				if (res.statusCode == 200) {
					const r = typeof res.data == 'string' ? JSON.parse(res.data) : res.data;
					if (r.code > 0) {
						resolve(r.data);
					}else if(r.code === -1000){
						uni.showModal({
						  title:'温馨提示',
						  content:'token失效，即将返回个人中心',
						  showCancel: false,
						  success: (res) => {
				            uni.reLaunch({
				                url: '/pages/home/homeIndex'
				            })
						  }
						})
					}else{
						reject(r);
					} 
				} else reject({ code: -500, msg: JSON.stringify(res) });
			},
			fail:(err)=> {
				// console.log(err, uri)
				reject({ code: -500, msg: JSON.stringify(err) });
			}
		});
	});
}