// 接口地址映射
const apiObj = {
	// 查询是不是最新版本号
	'appUpdate': `/mroapi/appsrv/appupgrade/selectLatestVersion`,
	// 下载安装包
	// 'appDownload': `/mroapi/appsrv/appupgrade/downloadApk`,
	'appDownload': `/mroapi/appsrv/objectStorage/GetDoc/downloadApk`,
	// 通过id下载apk安装包
	'downloadApkById': `/mroapi/appsrv/objectStorage/GetDoc/downloadApkById`,
	'lldcxhead': `/mroapi/appsrv/lingLiao/lldcxhead`, // 领料单查询head
	'lldcxitem': `/mroapi/appsrv/lingLiao/lldcxitem`,
	'lldlr': `/mroapi/appsrv/lingLiao/lldlr`, // 领料单录入
	'getUserAttributes': `/mroapi/appsrv/appuserattributes/page?`, // 获取人员配置属性
	'getMainData': `/mroapi/appsrv/mainData`, // 获取航材主数据
	'addFayun': `/mroapi/appsrv/fayundan/addFayun`, // 发运提交接口
	'getHangCaiInfo': `/mroapi/appsrv/appjiaweitiaozheng/getHangCaiInfo`, // 获取航材信息（下架）
	'appjiaweitiaozhengXj': `/mroapi/appsrv/appjiaweitiaozheng/save`, // 新增架位调整（提交下架数据）
	/**
	 * 发运单管理接口
	 */
	// 运单查询接口
	'getYdcxHead': `/mroapi/appsrv/fayundan/getYdcxHead`,
	// 运单查询接口
	'getYdcxItems': `/mroapi/appsrv/fayundan/getYdcxItems`,
	'getHangCaiInfoShang': `/mroapi/appsrv/appjiaweitiaozheng/getHangCaiInfoShang`, // 获取航材信息（上架）
	'appjiaweitiaozhengSj': `/mroapi/appsrv/appjiaweitiaozheng/submit`, // 提交上架数据以及日常盘点
	'appdaxinhuajiaweitiaozheng': `/mroapi/appsrv/kuaiSuYiKu/submit`, // 大新华架位调整
	'addTiyun': `/mroapi/appsrv/tiyun/addTiyun`, // 运单行李提交接口
	'setDefaultFactory': `/mroapi/appsrv/appuserfactory/default`, // 修改人员工厂默认属性
	'setDefaultWarehouse': `/mroapi/appsrv/appuserwarehouse/default`, // 修改人员仓库默认属性
	'setDefaultTerminal': `/mroapi/appsrv/appuserterminal/default`, // 修改人员航站默认属性
	'setDefaultStocklocation': `/mroapi/appsrv/appuserstocklocation/default`, // 修改人员库存地默认属性
	'getJiaWeiInfoRi': `/mroapi/appsrv/riChangPanDian/getJiaWeiInfo`, // 获取架位信息-日常盘点
	'riChangPanDian': `/mroapi/appsrv/riChangPanDian`, // 提交清点数据
	'getBdys': `/mroapi/appsrv/fayundan/getBdys`, // 本地运输查询接口
	'getYkzlHead': `/mroapi/appsrv/fayundan/getYkzlHead`, // 移库指令查询头接口
	'getYkzlItems': `/mroapi/appsrv/fayundan/getYkzlItems`, // 移库指令查询接口
	'addBdys': `/mroapi/appsrv/fayundan/addBdys`, // 本地运输提交接口
	'getYiDongDanInfo': `/mroapi/appsrv/zhengShuShangXiaJia/getYiDongDanInfo`, // 获取移动单信息
	'submitZhengShuYiDongDanSXJ': `/mroapi/appsrv/zhengShuShangXiaJia/submitZhengShuYiDongDanSXJ`, // 提交证书上下架数据
	'getJhpc': `/mroapi/appsrv/fayundan/getJhpc`, // 件号批次查询接口
	// 证书上下架
	'getZhengShuInfo': `/mroapi/appsrv/zhengShuShangXiaJia/getZhengShuInfo`, // 获取证书信息
	'submitTiaoZhengData': `/mroapi/appsrv/zhengShuShangXiaJia/submitTiaoZhengData`, // 提交调整数据
	'selectZhengShuSXJRecord': `/mroapi/appsrv/zhengShuShangXiaJia/selectZhengShuSXJRecord`, // 查询证书上下架记录
	// 提运接口
	'addYdtyqs': `/mroapi/appsrv/tiyun/addYdtyqs`, // 运单提运签收接口
	// 日常盘点
	'selectRiChangPanDianRecord': `/mroapi/appsrv/riChangPanDian/selectRiChangPanDianRecord`, // 查询日常盘点记录
	/**
	 * 运单分拣
	 */
	// 运单上下架接口
	'addSxj': `/mroapi/appsrv/yundanfenjian/addSxj`,
	// 运单分拣上下架历史记录查询接口
	'getLs': `/mroapi/appsrv/yundanfenjian/getLs`,
	// 运单分拣查询可下架信息接口
	'getKxj': `/mroapi/appsrv/yundanfenjian/getKxj`,
	// 运单分拣上下架历史记录附件查询接口
	'getYdfjLsFj': `/mroapi/appsrv/yundanfenjian/getLsFj`,
	// 架位调整
	'submitRiChangPanDian': `/mroapi/appsrv/appjiaweitiaozheng/submitRiChangPanDian`, // 提交日常盘点数据
	// 调配收料
	'addTpsl': `/mroapi/appsrv/tiaopeishouliao/addTpsl`, // 调配收料提交接口
	'getTpsl': `/mroapi/appsrv/tiaopeishouliao/getTpsl`, // 调配收料查询接口
	'getTpslZxd': `/mroapi/appsrv/tiaopeishouliao/getTpslZxd`, // 获取调配收料中装箱单查询接口
	// 交接签收
	'handoverSign': `/mroapi/appsrv/handoverSign`, // get:查询主表任务单,post:签收人签收
	'handoverSignInfo': `/mroapi/appsrv/handoverSign/info`, // 查询签收记录
	'handoverSignReturn': `/mroapi/appsrv/handoverSign/return`, // 退回查询
	'handoverSignAddTask': `/mroapi/appsrv/handoverSign/addTask`, // 提交航材单或运单，返回主表任务单号
	// 退料
	'addTuiliao': `/mroapi/appsrv/tuiliao/add`, // 退料单录入
	'getTuiliaoHead': `/mroapi/appsrv/tuiliao/getTuiliaoHead`,
	'getTuiliaoItem': `/mroapi/appsrv/tuiliao/getTuiliaoItem`,
	// 库存信息查询接口
	'getKucunxinxicx': `/mroapi/appsrv/hangcaixinxichaxun/getKucunxinxicx`,
	/**
	 * 航材打包
	 */
	// 获取装箱单查询接口
	'getZhuangxiangdan': `/mroapi/appsrv/hangcaidabao/getZhuangxiangdan`,
	// 获取周转箱查询接口
	'getZhouzhuanxiangcx': `/mroapi/appsrv/hangcaidabao/getZhouzhuanxiangcx`,
	// 获取发料记录查询接口
	'getFaliao': `/mroapi/appsrv/hangcaidabao/getFaliao`,
	// 装箱单提交接口
	'addZhuangxiangdan': `/mroapi/appsrv/hangcaidabao/addZhuangxiangdan`,
	// 装箱单打印获取接口
	'getZxdDY': `/mroapi/appsrv/hangcaidabao/getZxdDY`,
	// 获取装箱单附件接口
	'getZhuangxiangdanFj': `/mroapi/appsrv/hangcaidabao/getZhuangxiangdanFj`,
	/**
	 * 发料出库
	 */
	// CGAM预约包航材查询
	'getYybCx': `/mroapi/appsrv/dxhFaLiaoChuKu/getYybCx`,
	// 快速移库查询
	'getKuaiSuYiKu': `/mroapi/appsrv/kuaiSuYiKu/getKuaiSuYiKu`,
	// 快速移库提交
	'kuaiSuYiKuAdd': `/mroapi/appsrv/kuaiSuYiKu/add`,
	// GCAM发料记录查询接口
	'getFLJL': `/mroapi/appsrv/dxhFaLiaoChuKu/getFLJL`,
	// GCAM发料提交
	'gcamAddFL': `/mroapi/appsrv/dxhFaLiaoChuKu/addFL`,
	/**
	 * 工作上报
	 */
	// 工作包查询
	'workPackages': `/mroapi/appsrv/workPackages`,
	// 工作包工卡清单查询
	'workPackages-taskCardList': `/mroapi/appsrv/workPackages/taskCardList`,
	// 工卡反馈清单查询
	'workPackages-taskCardFeedbackList': `/mroapi/appsrv/workPackages/taskCardFeedbackList`,
	// 报工
	'workPackages-report': `/mroapi/appsrv/workPackages/report`,
	/**
	 * 大新华物流交接
	 */
	// 物流发出
	'gcamWlfc': `/mroapi/appsrv/daxinhuaLogistics/send`,
	// 物流接收
	'gcamWljs': `/mroapi/appsrv/daxinhuaLogistics/receive`,
	// 物流查询
	'gcamWlInfo': `/mroapi/appsrv/daxinhuaLogistics/info`,
	// getPersonInfo
	'getPersonInfo': `/mroapi/appsrv/daxinhuaLogistics/personInfo`,
	/**
	 * 航材上下架
	 */
	// 获取上下架信息
	'getDaiShangXiaJiaTask': `/mroapi/appsrv/hangCaiShangJia/getDaiShangXiaJiaTask`,
	// 获取架位信息
	'getJiaWeiInfo': `/mroapi/appsrv/hangCaiShangJia/getJiaWeiInfo`,
	// 提交上架数据以及日常盘点
	'hangCaiShangJia': `/mroapi/appsrv/hangCaiShangJia`,
	// 航材下架
	'hangCaiXiaJia': `/mroapi/appsrv/hangCaiShangJia/xiajia`,
	// 大新华-航材下架
	'hangCaiXiaJiaDxh': `/mroapi/appsrvhangCaiShangJia/dxhxj`,
	// 大新华-航材上架
	'hangCaiShangJiaDxh': `/mroapi/appsrvhangCaiShangJia/dxhsj`,
	// 提交日常盘点数据
	'saveRiChangPanDian': `/mroapi/appsrv/hangCaiShangJia/saveRiChangPanDian`,
	/**
	 * 可用库存
	 */
	// 获取库存
	'getKucun': `/mroapi/appsrv/kucun/getKucun`,
	// 禁限装查询接口
	'getJxz': `/mroapi/appsrv/jxz/getJxz`,
	// 件号互换
	'getHHJ': `/mroapi/appsrv/lingLiao/getHHJ`,
	/**
	 * 审批平台
	 */
	// 列表查询
	'approve-pendingList': `/mroapi/appsrv/approve/pendingList`,
	// 审批结果
	'approve-result': `/mroapi/appsrv/approve/result`,
	// 审批详情
	'approve-detail': `/mroapi/appsrv/approve/detail`,
	// 采购合同检查
	'purchaseOrder-getPurchaseOrder': `/mroapi/appsrv/purchaseOrder/getPurchaseOrder`,
	// 获取平均循环数
	'cycle': `/mroapi/appsrv/cycle`,
	// 获取飞机机型
	'getAircraftType': `/mroapi/appsrv/aircraftType/getAircraftType`,
	// 获取营运人
	'getZopInter': `/mroapi/appsrv/zopInter/getZopInter`,
	// 获取飞机预警到期
	'getAircraftWarning': `/mroapi/appsrv/aircraftWarning/getAircraftWarning`,
	// 获取飞机指令到期
	'getAircraftAcwo': `/mroapi/appsrv/aircraftAcwo/getAircraftAcwo`,
	// 航站选择组件
	'terminal-selectByName': `/mroapi/appsrv/terminal/select`,
	// 库存地查询
	'appstocklocation-page2': `/mroapi/appsrv/appstocklocation/page2`,
	// 退料拆换原因字典
	'appDict-tlReasonBy': `/mroapi/appsrv/appDict/tlReasonBy`,
	/**
	 * 领发料交接
	 */
	// 查询领发料交接单
	'lfl-getjjd': `/mroapi/appsrv/lfl/getjjd`,
	// 查询领发料交接单流程记录
	'lfl-getJhd': `/mroapi/appsrv/lfl/getJhd`,
	// 查询领发料详情记录
	'lfl-getLflxq': `/mroapi/appsrv/lfl/getLflxq`,
	// 我的航材列表
	'lfl-getMyHclb': `/mroapi/appsrv/lfl/getMyHclb`,
	// 领料单发起交接
	'lfl-fqjj': `/mroapi/appsrv/lfl/fqjj`,
	// 领料单接收
	'lfl-lldjs': `/mroapi/appsrv/lfl/lldjs`,
	// 领料单操作接口（接收、交出、删除）
	'lfl-tjjs': `/mroapi/appsrv/lfl/tjjs`,
	// 查询领发料交接单--机号、打印序号
	'lfl-getSta10': `/mroapi/appsrv/lfl/getSta10`,

	// get-nff获取NFF post-nff提交、编辑NFF数据
	'lfl-nff': `/mroapi/appsrv/nff`,
	/**
	 * 退料交接
	 */
	// 查询领退料交接单
	'tl-getjjd': `/mroapi/appsrv/tl/getjjd`,
	// 查询退料交接单流程记录
	'tl-getJhd': `/mroapi/appsrv/tl/getJhd`,
	// 查询退料详情记录
	'tl-getLflxq': `/mroapi/appsrv/tl/getLflxq`,
	// 我的航材列表
	'tl-getMyHclb': `/mroapi/appsrv/tl/getMyHclb`,
	// 退料单发起交接
	'tl-fqjj': `/mroapi/appsrv/tl/fqjj`,
	// 退料单接收
	'tl-lldjs': `/mroapi/appsrv/tl/lldjs`,
	// 退料单操作接口（接收、交出、删除）
	'tl-tjjs': `/mroapi/appsrv/tl/tjjs`,
	// 查询退料交接单--机号、打印序号
	'tl-getSta10': `/mroapi/appsrv/tl/getSta10`
}
export default apiObj