import {
	request,
	ipPrefix
} from '@/utils/request';
import dictionaryApi from '@/utils/dictionary';
import apiMapper from '@/apiMapper/index.js';

// 文件下载
export function fileDownload(type, url) {
	var name = 'test' + type;
	var dtask = plus.downloader.createDownload(url, {
		filename: "_downloads/" + name
	}, function(d, status) {
		if (status == 200) {
			var fileSaveUrl = plus.io.convertLocalFileSystemURL(d.filename);
			plus.runtime.openFile(fileSaveUrl); //选择软件打开文件
		} else {
			plus.downloader.clear(); //清除下载任务
		}
	})
	try {
		dtask.start(); // 开启下载的任务
		if (typeof(plus) != 'undefined') {
			var showLoading = plus.nativeUI.showWaiting('正在下载'); //创建一个showWaiting对象
			dtask.addEventListener('statechanged',
				function(task, status) {
					// 给下载任务设置一个监听 并根据状态  做操作
					switch (task.state) {
						case 1:
							showLoading
								.setTitle(
									'正在下载');
							break;
						case 2:
							showLoading
								.setTitle(
									'已连接到服务器');
							break;
						case 3:
							// 数值显示不正确
							let progressVal = 0;
							progressVal = Math.ceil(task.downloadedSize / task.totalSize) * 100;
							showLoading.setTitle('正在下载' + progressVal + '%  ');
							break;
						case 4:
							plus.nativeUI.closeWaiting(); //下载完成
							break;
					}
				});
		}
	} catch (err) {
		uni.showToast({
			title: '更新失败-03',
			mask: false,
			duration: 1500
		});
	}
}

// 二代检查app更新
/**
 	import {
		checkAppUpdates
	} from '../../common/appUpdate.js';
	checkAppUpdates();
 */
let totalFileSize = 0;

export function secondGenerationAppUpdate(appVersion, type) {
	let requestData = {
		appVersion: appVersion,
		systemType: type
	};

	request({
			method: 'POST',
			url: 'appUpgradeAll',
			data: requestData
		}, false, true)
		.then(res => {
			console.log(res)
			if (res.code == 0) {
				// 判断版本是否有效
				totalFileSize = res.data.totalFileSize;

				if (res.data.effective == 1 || compareVersions(appVersion, res.data.appVersion) != -1) {
					uni.showToast({
						title: '检测到最新版本无效，不进行更新',
						icon: 'none'
					});
					return;
				}
				// 当前版本和接口返回来的版本做比较，
				if (compareVersions(appVersion, res.data.appVersion) == -1) {
					// uni.getSystemInfo({
					// success: function(e) {
					// if (e.platform == 'ipa') {
					if (res.data.applicationType == 'ipa') {
						dictionaryApi.getDictionarynoall('iosAddress').then(dictRes => {
							let showContent = '最新版本：' + res.data.appVersion + '\n\n更新内容：' + res.data.remark;
							uni.showModal({
								//提醒用户更新
								title: '更新提示',
								content: `${showContent}\n更新步骤如下\n1、点击确认APP会拷贝集团商店的访问地址(https://hnastore.hnagroup.com)。\n2、进入safari浏览器地址栏粘贴，然后在集团应用商店安装最新版本。`,
								success: res1 => {
									if (res1.confirm) {
										uni.setClipboardData({
											data: dictRes.data[0].label,
											success: function() {
												console.log('success');
											}
										});
									}
								}
							});
						});
					} else {
						// 强制更新下载
						if (res.data.forceUpgrade == 1) {
							updateDownload(res.data.applicationType, res.data.id);
							return
						}
						// 正常更新下载
						let showContent = '最新版本：' + res.data.appVersion + '\n\n更新内容：' + res.data.remark;
						uni.showModal({
							//提醒用户更新
							title: '更新提示',
							content: showContent,
							success: res1 => {
								if (res1.confirm) {
									updateDownload(res.data.applicationType, res.data.id);
								}

							}
						});
					}
					// }
					// });
				}
			} else if (res.code == 1) {
				// 已是最新版本
				uni.showToast({
					title: res.msg,
					icon: 'success'
				});
			}
		})
		.catch(err => {
			console.log(err);
		});
}

// 比较两个版本号的大小 1 2
function compareVersions(version1, version2) {
	// 将版本号拆分成数字数组
	var arr1 = version1.split('.');
	var arr2 = version2.split('.');

	// 遍历数字数组进行逐段比较
	for (var i = 0; i < Math.max(arr1.length, arr2.length); i++) {
		var num1 = parseInt(arr1[i] || 0); // 如果数组长度不够，则将缺失部分补0
		var num2 = parseInt(arr2[i] || 0);

		if (num1 < num2) {
			return -1; // 版本1小于版本2
		} else if (num1 > num2) {
			return 1; // 版本1大于版本2
		}
	}

	return 0; // 版本1等于版本2
}

//设置 最新版本apk的下载链接
let urlPrefix = !!uni.getStorageSync('urlPrefix') ? uni.getStorageSync('urlPrefix') : ipPrefix;

// 更新下载
function updateDownload(type, id) {
	// wgt热部署更新
	if (type == 'wgt') { // wgt apk
		downloadWgt(id); // 下载wgt方法
	} else {
		// //设置 最新版本apk的下载链接
		// let urlPrefix = !!uni.getStorageSync(
		// 	'urlPrefix') ? uni.getStorageSync(
		// 	'urlPrefix') : ipConfig;
		var downloadApkUrl = urlPrefix + apiMapper['downloadApkByIdAll'] + '?id=' + id;
		let name = id + '.apk';
		var dtask = plus.downloader.createDownload(
			downloadApkUrl, {
				// 利用保存路径，实现下载文件的重命名
				filename: '_downloads/' + name
			},
			function(d, status) {
				// 下载完成
				if (status == 200) {
					if (typeof(plus) !=
						'undefined') {
						plus.runtime.install(plus.io.convertLocalFileSystemURL(d.filename), {}, {},function(error) {
							uni.showToast({
								title: '安装失败',
								duration: 1500
							});
						});
					}
				} else {
					//下载失败
					uni.showToast({
						title: '更新失败',
						duration: 1500
					});
					if (typeof(plus) != 'undefined') {
						plus.downloader.clear(); //清除下载任务
					}
				}
			}
		);
		try {
			dtask.start(); // 开启下载的任务
			var prg = 0;
			if (typeof(plus) != 'undefined') {
				var showLoading = plus.nativeUI.showWaiting('正在下载'); //创建一个showWaiting对象
				dtask.addEventListener('statechanged',
					function(task, status) {
						console.log(task);
						// 给下载任务设置一个监听 并根据状态  做操作
						switch (task.state) {
							case 1:
								showLoading
									.setTitle(
										'正在下载');
								break;
							case 2:
								showLoading
									.setTitle(
										'已连接到服务器');
								break;
							case 3:
								// 数值显示不正确
								let pr = Math.floor(((task.downloadedSize || 0) / (totalFileSize || 0)) * 100);
								showLoading.setTitle('正在下载' + pr + '%');
								break;
							case 4:
								plus.nativeUI
									.closeWaiting();
								//下载完成
								break;
						}
					});
			}
		} catch (err) {
			uni.showToast({
				title: '更新失败-03',
				mask: false,
				duration: 1500
			});
		}
	}
}

const currentUrl = window.location;

// 下载wgt方法
function downloadWgt(id) {
	// 更新文件 wgt 文件地址
	let wgtUrl = urlPrefix + apiMapper['downloadApkByIdAll'] + '?id=' + id;
	let options = {
		method: "get",
		filename: "_doc/update/" + new Date().getTime() + ".wgt" // 设置后缀名
	};
	// plus.nativeUI.showWaiting();
	let dTask = plus.downloader.createDownload(wgtUrl, options, function(d, status) {
		if (status == 200) {
			installWgt(d.filename); // 安装wgt方法
		} else {
			plus.nativeUI.alert("下载wgt失败！");
		}
		plus.nativeUI.closeWaiting();
	})
	try {
		dTask.start(); // 开启下载的任务
		var prg = 0;
		if (typeof(plus) != 'undefined') {
			var showLoading = plus.nativeUI.showWaiting("正在更新..."); //创建一个showWaiting对象
			dTask.addEventListener('statechanged',
				function(task, status) {
					// 给下载任务设置一个监听 并根据状态  做操作
					switch (task.state) {
						case 1:
							showLoading.setTitle('正在下载');
							break;
						case 2:
							showLoading.setTitle('已连接到服务器');
							break;
						case 3:
							// 数值显示不正确
							let progressVal = 0; //写成局部变量试试
							console.log(task)
							progressVal = (((task.downloadedSize / totalFileSize).toFixed(2)) * 100).toFixed(2);
							showLoading.setTitle('正在下载' + progressVal + '%  '); 
							// showLoading
							// 	.setTitle(
							// 		'正在下载');
							break;
						case 4:
							// plus.nativeUI.closeWaiting();
							//下载完成
							break;
					}
				});
		}
	} catch (err) {
		// plus.nativeUI.closeWaiting();
		uni.showToast({
			title: '更新失败-03',
			mask: false,
			duration: 1500
		});
	}
}

// 安装wgt方法
function installWgt(path) {
	plus.nativeUI.showWaiting("安装wgt文件...");
	plus.runtime.install(path, {
		force: true
	}, function() {
		plus.nativeUI.closeWaiting();
		plus.nativeUI.alert("应用资源更新完成！", function() {
			plus.runtime.restart();
		});
	}, function(e) {
		plus.nativeUI.closeWaiting();
		plus.nativeUI.alert("安装wgt文件失败[" + e.code + "]：" + e.message);
	});
}

// 检测APP更新
export function checkAppUpdate(appVersion) {
	let requestData = {
		appType: '1',
		appVersion: appVersion
	};
	request({
			method: 'GET',
			url: 'appUpdate',
			data: requestData
		})
		.then(res => {
			if (res.code == 0) {
				if (appVersion != res.data.appVersion) {
					// 判断版本是否有效
					if (res.data.effective == 1) {
						uni.showToast({
							title: '检测到最新版本无效，不进行更新',
							icon: 'none'
						});
						return;
					}
					uni.getSystemInfo({
						success: function(e) {
							console.log(e)
							// Vue.prototype.StatusBar = e.statusBarHeight;
							if (e.platform == 'ipa') {
								uni.showModal({
									//提醒用户更新
									title: '更新提示',
									content: 'AMMS APP有新版本，更新步骤如下 ：1 点击确认APP会拷贝集团商店的访问地址(https://hnastore.hnagroup.com)。2卸载当前版本APP。3 进入safari浏览器地址栏粘贴，然后在集团应用商店安装最新版本。',
									success: res1 => {
										uni.setClipboardData({
											data: 'https://hnastore.hnagroup.com',
											success: function() {
												console.log('success');
											}
										});
									}
								});
							} else {
								let showContent = '最新版本：' + res.data.appVersion + '\n\n更新内容：' + res.data
									.remark;
								if (res.data.forceUpgrade == 1) {
									showContent = showContent + '：强制更新';
								}
								uni.showModal({
									//提醒用户更新
									title: '更新提示',
									content: showContent,
									success: res1 => {
										if (res1.confirm) {
											//设置 最新版本apk的下载链接
											let urlPrefix = !!uni.getStorageSync('urlPrefix') ? uni.getStorageSync('urlPrefix') : ipPrefix;
											var downloadApkUrl = urlPrefix + apiMapper['downloadApkById'] + '?id=' + res.data.id;
											let name = res.data.id + '.apk';

											var dtask = plus.downloader.createDownload(
												downloadApkUrl, {
													// 利用保存路径，实现下载文件的重命名
													filename: '_downloads/' + name
												},
												function(d, status) {
													// 下载完成
													if (status == 200) {
														if (typeof(plus) !=
															'undefined') {
															plus.runtime.install(plus.io
																.convertLocalFileSystemURL(
																	d.filename
																), {}, {},
																function(error) {
																	uni.showToast({
																		title: '安装失败',
																		duration: 1500
																	});
																});
														}
													} else {
														//下载失败
														uni.showToast({
															title: '更新失败',
															duration: 1500
														});
														if (typeof(plus) !=
															'undefined') {
															plus.downloader
																.clear(); //清除下载任务
														}
													}
												}
											);
											try {
												dtask.start(); // 开启下载的任务
												var prg = 0;
												if (typeof(plus) != 'undefined') {
													var showLoading = plus.nativeUI
														.showWaiting(
															'正在下载'); //创建一个showWaiting对象
													dtask.addEventListener('statechanged',
														function(task, status) {
															// 给下载任务设置一个监听 并根据状态  做操作
															switch (task.state) {
																case 1:
																	showLoading
																		.setTitle(
																			'正在下载');
																	break;
																case 2:
																	showLoading
																		.setTitle(
																			'已连接到服务器');
																	break;
																case 3:
																	// 数值显示不正确
																	let progressVal =
																		0; //写成局部变量试试
																	progressVal = Math
																		.ceil(task
																			.downloadedSize /
																			task
																			.totalSize
																		) * 100;
																	// showLoading.setTitle('正在下载' + progressVal + '%  '); 
																	showLoading
																		.setTitle(
																			'正在下载');
																	break;
																case 4:
																	plus.nativeUI
																		.closeWaiting();
																	//下载完成
																	break;
															}
														});
												}
											} catch (err) {
												// plus.nativeUI.closeWaiting();
												uni.showToast({
													title: '更新失败-03',
													mask: false,
													duration: 1500
												});
											}
											// dtask.start();
										} else if (res1.cancel) {}
									}
								});
							}
						}
					});
				}
			} else if (res.code == 1) {
				// 已是最新版本
				uni.showToast({
					title: res.msg,
					icon: 'success'
				});
			}
		})
		.catch(err => {
			console.log(err);
		});
}


// if (res1.confirm) {
// 	// wgt热部署更新
// 	if(res.data.applicationType == 'wgt'){ // wgt apk
// 		downloadWgt(res.data.id); // 下载wgt方法
// 	}else{
// 		const downloadTask = uni.downloadFile({
// 			url: apiMapper['downloadApkByIdAll'] + '?id=' + res.data.id,
// 			success: (downloadResult) => {
// 				plus.runtime.install(
// 					downloadResult.tempFilePath, {
// 						force: false
// 					},() => {
// 						plus.runtime.restart();
// 					},(e) => {
// 						console.log(e)
// 					}
// 				);
// 			}
// 		});
// 		// 下载进度
// 		downloadTask.onProgressUpdate((res) => {
// 			let percent = (res.totalBytesWritten / totalFileSize).toFixed(2) 
// 			uni.showLoading({
// 				title: "下载进度: " + Math.floor(percent * 100) + "%",
// 			})
// 			if(percent >= 1){
// 				uni.hideLoading();
// 			}
// 			return
// 		});

// 	}
// }