/**
 * 检验站点输入，限制3个大写英文字母
 * @param {Object} value
 */
export function checkZapt3(value) {
	var filter = /^[a-z]+$/i;
	let blnTest = filter.test(value)
	if (value.length != 3 || !blnTest) {
		return false
	}
	return true
}

/**
 * 获取当前日期
 */
export function getNowDate() {
	var aData = new Date();
	var mon = aData.getMonth() + 1; //getMonth()返回的是0-11，则需要加1
	if (mon <= 9) { //如果小于9的话，则需要加上0
		mon = "0" + mon;
	}
	var day = aData.getDate(); //getdate()返回的是1-31，则不需要加1
	if (day <= 9) { //如果小于9的话，则需要加上0
		day = "0" + day;
	}
	let value = aData.getFullYear() + '-' + mon + '-' + day;
	return value
}

/**
 * 清空缓存
 */
export function clearStorageFun() {
	try {
		// uni.clearStorageSync();
		// 清空应用缓存，urlPrefix(接口ip配置)不能清除
		uni.removeStorageSync('loginType');
		uni.removeStorageSync('access_token');
		uni.removeStorageSync('refresh_token');
		uni.removeStorageSync('license');
		uni.removeStorageSync('username');
		uni.removeStorageSync('userid');
		uni.removeStorageSync('userAppId');
		uni.removeStorageSync('appVersion');
		uni.removeStorageSync('permissions');
		uni.removeStorageSync('phone');
		uni.removeStorageSync('deptName');
		uni.removeStorageSync('factoryList');
		uni.removeStorageSync('terminalList');
		uni.removeStorageSync('userTerminal');
		uni.removeStorageSync('userTerminalValue');
		uni.removeStorageSync('stockLocationList');
		uni.removeStorageSync('userStock');
		uni.removeStorageSync('userStockValue');
		uni.removeStorageSync('userPrinterList');
		uni.removeStorageSync('userDefaultPrinter');
		uni.removeStorageSync('userFactory');
		uni.removeStorageSync('userFactoryId');
		uni.removeStorageSync('warehouseList');
		uni.removeStorageSync('userWarehouse');
		uni.removeStorageSync('userWarehouseId');
	} catch (e) {
		// error
	}
}

/**
 * Parse the time to string
 * @param {(Object|string|number)} time
 * @param {string} cFormat
 * @returns {string | null}
 */
export function parseTime(time, cFormat) {
	if (arguments.length === 0) {
		return null
	}
	const format = cFormat || '{y}-{m}-{d} {h}:{i}:{s}'
	let date
	if (typeof time === 'object') {
		date = time
	} else {
		if (typeof time === 'string' && /^[0-9]+$/.test(time)) {
			time = parseInt(time)
		}
		if (typeof time === 'number' && time.toString().length === 10) {
			time = time * 1000
		}
		date = new Date(time)
	}
	const formatObj = {
		y: date.getFullYear(),
		m: date.getMonth() + 1,
		d: date.getDate(),
		h: date.getHours(),
		i: date.getMinutes(),
		s: date.getSeconds(),
		a: date.getDay()
	}
	const time_str = format.replace(/{([ymdhisa])+}/g, (result, key) => {
		const value = formatObj[key]
		// Note: getDay() returns 0 on Sunday
		if (key === 'a') {
			return ['日', '一', '二', '三', '四', '五', '六'][value]
		}
		return value.toString().padStart(2, '0')
	})
	return time_str
}

/**
 * @param {number} time
 * @param {string} option
 * @returns {string}
 */
export function formatTime(time, option) {
	if (('' + time).length === 10) {
		time = parseInt(time) * 1000
	} else {
		time = +time
	}
	const d = new Date(time)
	const now = Date.now()

	const diff = (now - d) / 1000

	if (diff < 30) {
		return '刚刚'
	} else if (diff < 3600) {
		// less 1 hour
		return Math.ceil(diff / 60) + '分钟前'
	} else if (diff < 3600 * 24) {
		return Math.ceil(diff / 3600) + '小时前'
	} else if (diff < 3600 * 24 * 2) {
		return '1天前'
	}
	if (option) {
		return parseTime(time, option)
	} else {
		return (
			d.getMonth() +
			1 +
			'月' +
			d.getDate() +
			'日' +
			d.getHours() +
			'时' +
			d.getMinutes() +
			'分'
		)
	}
}

/**
 * @param {string} url
 * @returns {Object}
 */
export function getQueryObject(url) {
	url = url == null ? window.location.href : url
	const search = url.substring(url.lastIndexOf('?') + 1)
	const obj = {}
	const reg = /([^?&=]+)=([^?&=]*)/g
	search.replace(reg, (rs, $1, $2) => {
		const name = decodeURIComponent($1)
		let val = decodeURIComponent($2)
		val = String(val)
		obj[name] = val
		return rs
	})
	return obj
}

/**
 * @param {string} input value
 * @returns {number} output value
 */
export function byteLength(str) {
	// returns the byte length of an utf8 string
	let s = str.length
	for (var i = str.length - 1; i >= 0; i--) {
		const code = str.charCodeAt(i)
		if (code > 0x7f && code <= 0x7ff) s++
		else if (code > 0x7ff && code <= 0xffff) s += 2
		if (code >= 0xdc00 && code <= 0xdfff) i--
	}
	return s
}

/**
 * @param {Array} actual
 * @returns {Array}
 */
export function cleanArray(actual) {
	const newArray = []
	for (let i = 0; i < actual.length; i++) {
		if (actual[i]) {
			newArray.push(actual[i])
		}
	}
	return newArray
}

/**
 * @param {Object} json
 * @returns {Array}
 */
export function param(json) {
	if (!json) return ''
	return cleanArray(
		Object.keys(json).map(key => {
			if (json[key] === undefined) return ''
			return encodeURIComponent(key) + '=' + encodeURIComponent(json[key])
		})
	).join('&')
}

/**
 * @param {string} url
 * @returns {Object}
 */
export function param2Obj(url) {
	const search = url.split('?')[1]
	if (!search) {
		return {}
	}
	return JSON.parse(
		'{"' +
		decodeURIComponent(search)
		.replace(/"/g, '\\"')
		.replace(/&/g, '","')
		.replace(/=/g, '":"')
		.replace(/\+/g, ' ') +
		'"}'
	)
}

/**
 * @param {string} val
 * @returns {string}
 */
export function html2Text(val) {
	const div = document.createElement('div')
	div.innerHTML = val
	return div.textContent || div.innerText
}

/**
 * Merges two objects, giving the last one precedence
 * @param {Object} target
 * @param {(Object|Array)} source
 * @returns {Object}
 */
export function objectMerge(target, source) {
	if (typeof target !== 'object') {
		target = {}
	}
	if (Array.isArray(source)) {
		return source.slice()
	}
	Object.keys(source).forEach(property => {
		const sourceProperty = source[property]
		if (typeof sourceProperty === 'object') {
			target[property] = objectMerge(target[property], sourceProperty)
		} else {
			target[property] = sourceProperty
		}
	})
	return target
}

/**
 * @param {HTMLElement} element
 * @param {string} className
 */
export function toggleClass(element, className) {
	if (!element || !className) {
		return
	}
	let classString = element.className
	const nameIndex = classString.indexOf(className)
	if (nameIndex === -1) {
		classString += '' + className
	} else {
		classString =
			classString.substr(0, nameIndex) +
			classString.substr(nameIndex + className.length)
	}
	element.className = classString
}

/**
 * @param {string} type
 * @returns {Date}
 */
export function getTime(type) {
	if (type === 'start') {
		return new Date().getTime() - 3600 * 1000 * 24 * 90
	} else {
		return new Date(new Date().toDateString())
	}
}

/**
 * @param {Function} func
 * @param {number} wait
 * @param {boolean} immediate
 * @return {*}
 */
export function debounce(func, wait, immediate) {
	let timeout, args, context, timestamp, result

	const later = function() {
		// 据上一次触发时间间隔
		const last = +new Date() - timestamp

		// 上次被包装函数被调用时间间隔 last 小于设定时间间隔 wait
		if (last < wait && last > 0) {
			timeout = setTimeout(later, wait - last)
		} else {
			timeout = null
			// 如果设定为immediate===true，因为开始边界已经调用过了此处无需调用
			if (!immediate) {
				result = func.apply(context, args)
				if (!timeout) context = args = null
			}
		}
	}

	return function(...args) {
		context = this
		timestamp = +new Date()
		const callNow = immediate && !timeout
		// 如果延时不存在，重新设定延时
		if (!timeout) timeout = setTimeout(later, wait)
		if (callNow) {
			result = func.apply(context, args)
			context = args = null
		}

		return result
	}
}

/**
 * This is just a simple version of deep copy
 * Has a lot of edge cases bug
 * If you want to use a perfect deep copy, use lodash's _.cloneDeep
 * @param {Object} source
 * @returns {Object}
 */
export function deepClone(source) {
	if (!source && typeof source !== 'object') {
		throw new Error('error arguments', 'deepClone')
	}
	const targetObj = source.constructor === Array ? [] : {}
	Object.keys(source).forEach(keys => {
		if (source[keys] && typeof source[keys] === 'object') {
			targetObj[keys] = deepClone(source[keys])
		} else {
			targetObj[keys] = source[keys]
		}
	})
	return targetObj
}

/**
 * 深拷贝
 * @param {Object} data
 */
export function deepCloneNew(data) {
	let _data = JSON.stringify(data),
		dataClone = JSON.parse(_data);
	return dataClone;
};

/**
 * 过滤数组重复数据
 * @param {Array} arr
 * @returns {Array}
 */
export function uniqueArr(arr) {
	return Array.from(new Set(arr))
}

/**
 * @returns {string}
 */
export function createUniqueString() {
	const timestamp = +new Date() + ''
	const randomNum = parseInt((1 + Math.random()) * 65536) + ''
	return (+(randomNum + timestamp)).toString(32)
}

/**
 * 生成随机len位数字
 */
export const randomLenNum = (len, date) => {
	let random = ''
	random = Math.ceil(Math.random() * 100000000000000).toString().substr(0, len || 4)
	if (date) random = random + Date.now()
	return random
}

/**
 * Check if an element has a class
 * @param {HTMLElement} elm
 * @param {string} cls
 * @returns {boolean}
 */
export function hasClass(ele, cls) {
	return !!ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'))
}

/**
 * Add class to element
 * @param {HTMLElement} elm
 * @param {string} cls
 */
export function addClass(ele, cls) {
	if (!hasClass(ele, cls)) ele.className += ' ' + cls
}

/**
 * Remove class from element
 * @param {HTMLElement} elm
 * @param {string} cls
 */
export function removeClass(ele, cls) {
	if (hasClass(ele, cls)) {
		const reg = new RegExp('(\\s|^)' + cls + '(\\s|$)')
		ele.className = ele.className.replace(reg, ' ')
	}
}

/**
 * 判断是否数字
 *
 * @export
 * @param {*} obj
 * @returns
 */
export function isNumber(obj) {
	var reg = /^[0-9]+.?[0-9]*$/
	if (reg.test(obj)) {
		return true
	}
	return false
}

/**
 * 数组根据数组对象中的某个属性值进行排序的方法
 * 使用例子：newArray.sort(sortBy('number',false))
 * 表示根据number属性降序排列;若第二个参数不传递，默认表示升序排序
 * @export
 * @param {*} attr 排序的属性 如number属性
 * @param {*} rev true表示升序排列，false降序排序
 * @returns
 */
export function sortBy(attr, rev) {
	// 第二个参数没有传递 默认升序排列
	if (rev === undefined) {
		rev = 1
	} else {
		rev = (rev) ? 1 : -1
	}

	return function(a, b) {
		a = a[attr]
		b = b[attr]
		if (a < b) {
			return rev * -1
		}
		if (a > b) {
			return rev * 1
		}
		return 0
	}
}

/**
 * 生成唯一ID
 * @returns {string}
 */
export function generateUUID() {
	var d = new Date().getTime()
	if (window.performance && typeof window.performance.now === 'function') {
		d += performance.now() // use high-precision timer if available
	}
	var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(
		c
	) {
		var r = (d + Math.random() * 16) % 16 | 0
		d = Math.floor(d / 16)
		return (c === 'x' ? r : (r & 0x3) | 0x8).toString(16)
	})
	return uuid
}

/**
 * 通过value获取key值
 * @param {Object} obj
 * @param {Object} value
 */
export function getPickerKey(obj, value) {
	let key = '';
	for (var a in obj) {
		if (obj[a] == value) {
			key = a
		}
	}
	return key;
}

/**
 * 获取key值
 */
export function findKey(obj, value, compare = (a, b) => a === b) {
	return Object.keys(obj).find(k => compare(obj[k], value))
}

/**
 * 节流throttle
 */
export function throttle(func, wait) {
    let timeout; 
    return function () {
        let context = this;
        let args = arguments;
        if (!timeout) {
			timeout = setTimeout(() => {
			   timeout = null;
			   func.apply(context, args)
			}, wait)
		}
    };
}

/**
 * 根据接口返回的数据获取响应的过滤条件数据源
 */ 
export function getSource(list, type, json){
	if(json){
		const {key, value} = json
		const arr = []
		list.forEach(v=>{
			if(v[type]){
				arr.push({ key: v[key],	value: v[value] })
			}
		})
		return arr.filter((currentValue, currentIndex, sourceArr)=>{
			return sourceArr.findIndex(x=> x.key === currentValue.key) === currentIndex
		}).filter(s=>{
			return s.key && s.key.trim()
		})
	}else{
		return Array.from(new Set(list.map(v=>v[type]))).filter(s=>{
			return s && s.trim()
		})
	}
}