import {
    aem_surveyListSelect as surveyListSelect,
    aem_completeListSelect as completeListSelect,
    aem_auditListSelect as auditListSelect
} from 'mocp/hooks/use-dict/dict-data'

export const rowClassName = (rowData) => {
    let color = ''
    if (
        rowData.survey !== '' &&
        getValueBySelect(surveyListSelect, rowData.survey) !== '已反馈' &&
        getValueBySelect(surveyListSelect, rowData.survey) !== '不涉及' &&
        rowData.surveyTimeLimit !== null &&
        rowData.surveyTimeLimit !== 0
    ) {
        color = getRecordData(rowData.surveyTimeLimit, 1)
    }
    if (
        rowData.correctiveComplete !== '' &&
        getValueBySelect(completeListSelect, rowData.correctiveComplete) !== '已完成' &&
        getValueBySelect(completeListSelect, rowData.correctiveComplete) !== '不涉及' &&
        rowData.correctiveTimeLimit !== null &&
        rowData.correctiveTimeLimit !== 0
    ) {
        if (color == '') {
            color = getRecordData(rowData.correctiveTimeLimit, 3)
        } else if (color == 'warning-class') {
            color = getRecordData(rowData.correctiveTimeLimit, 3) == 'wrong-class' ? getRecordData(rowData.correctiveTimeLimit, 3) : color
        }
    }
    if (getValueBySelect(auditListSelect, rowData.reviewedState) == '审核通过') {
        color = 'cancel-class'
    }
    return color
}
export const getValueBySelect = (selectList, val) => {
    if (val == '' || val == undefined) {
        return
    } else {
        const findSelectObj = selectList.find((item) => item.value == val)
        return findSelectObj?.label
    }
}
export const getRecordData = (data, index) => {
    let colorValue = ''
    if (data == null) {
        colorValue = ''
    } else if (data < new Date().getTime()) {
        colorValue = 'wrong-class'
    } else if (new Date().getTime() >= workDayAhead(data, index)) {
        colorValue = 'warning-class'
    }
    return colorValue
}
const getHolidayDiff = (count, start) => {
    return Array(count)
        .fill(start)
        .map(function (_, index) {
            if (index === 0) return new Date(_).getTime()
            return new Date(_).getTime() + dayTS * index
        })
}
const dayTS = 1000 * 3600 * 24
const holidaySet = [...getHolidayDiff(3, '2023-06-22 00:00:00.000'), ...getHolidayDiff(8, '2023-09-29 00:00:00.000')]
const weekHoliday = [0, 6]
export function workDayAhead(tarTime, dayDiffer) {
    let tsNow = new Date(tarTime)
    tsNow.setHours(0, 0, 0, 0)
    tsNow = tsNow.getTime()
    while (dayDiffer > 0) {
        tsNow -= dayTS
        const weekDay = new Date(tsNow).getDay()
        if (!holidaySet.includes(tsNow) && !weekHoliday.includes(weekDay)) {
            dayDiffer--
        }
    }
    return tsNow
}
