import { reactive, ref } from 'vue'

export const formData = reactive({
    acreg: '',
    aircaraftoperator: '',
    antiicingCartNo1: '',
    antiicingCartNo2: '',
    antiicingCartNo3: '',
    antiicingCartNo4: '',
    antiicingDuration: '',
    antiicingEndTime: '',
    antiicingMix: '100:0',
    antiicingMix1: undefined,
    antiicingMix2: undefined,
    antiicingPersion1: '',
    antiicingPersion2: '',
    antiicingPersion3: '',
    antiicingPersion4: '',
    antiicingQuantity1: undefined,
    antiicingQuantity2: undefined,
    antiicingQuantity3: undefined,
    antiicingQuantity4: undefined,
    antiicingQuantityTotal: undefined,
    antiicingStartTime: '',
    antiicingType: '',
    antiicingUnit1: '',
    antiicingUnit2: '',
    antiicingUnit3: '',
    antiicingUnit4: '',

    antiicing2CartNo1: '',
    antiicing2CartNo2: '',
    antiicing2CartNo3: '',
    antiicing2CartNo4: '',
    antiicing2Duration: '',
    antiicing2EndTime: '',
    antiicing2Mix: '100:0',
    antiicing2Mix1: undefined,
    antiicing2Mix2: undefined,
    antiicing2Persion1: '',
    antiicing2Persion2: '',
    antiicing2Persion3: '',
    antiicing2Persion4: '',
    antiicing2Quantity1: undefined,
    antiicing2Quantity2: undefined,
    antiicing2Quantity3: undefined,
    antiicing2Quantity4: undefined,
    antiicing2QuantityTotal: undefined,
    antiicing2StartTime: '',
    antiicing2Type: '',
    antiicing2Unit1: '',
    antiicing2Unit2: '',
    antiicing2Unit3: '',
    antiicing2Unit4: '',

    customerSignImg: '',
    date: '',
    deicingCartNo1: '',
    deicingCartNo2: '',
    deicingCartNo3: '',
    deicingCartNo4: '',
    deicingEndTime: '',
    deicingMix: '50:50',
    deicingMix1: undefined,
    deicingMix2: undefined,
    deicingPersion1: '',
    deicingPersion2: '',
    deicingPersion3: '',
    deicingPersion4: '',
    deicingQuantity1: undefined,
    deicingQuantity2: undefined,
    deicingQuantity3: undefined,
    deicingQuantity4: undefined,
    deicingQuantityTotal: undefined,
    deicingStartTime: '',
    deicingType: '',
    deicingUnit1: '',
    deicingUnit2: '',
    deicingUnit3: '',
    deicingUnit4: '',
    expectDeicing: '0',
    fixedPointDeicing: '0',
    flightNoIn: '',
    flightNoOut: '',
    id: undefined,
    legs: '',
    model: '',
    nickname: '',
    originalAircraftPositionDeicing: '0',
    station: '',
    username: '',
    guaranteeUnit: '',
    weatherToday: '',
    modelType: '',
    remark: '',
    deicingFile: '',
    deicingRemark: '',
    antiicingFile: '',
    antiicingRemark: '',
    antiicing2File: '',
    antiicing2Remark: ''
})

export const rules = reactive({
    station: [
        {
            required: true,
            message: '请选择航站',
            trigger: ['blur', 'change']
        }
    ],
    date: [
        {
            type: 'number',
            required: true,
            message: '请选择日期',
            trigger: ['blur', 'change']
        }
    ],
    acreg: [
        {
            required: true,
            message: '请选择机号',
            trigger: ['blur', 'change']
        }
    ],
    aircaraftoperator: [
        {
            required: true,
            message: '请选择飞机所属单位',
            trigger: ['blur', 'change']
        }
    ],
    model: [
        {
            required: true,
            message: '请选择机型',
            trigger: ['blur', 'change']
        }
    ],
    guaranteeUnit: [
        {
            required: true,
            message: '请选择保障单位',
            trigger: ['blur', 'change']
        }
    ],
    weatherToday: [
        {
            required: true,
            message: '请选择当日天气',
            trigger: ['blur', 'change']
        }
    ],
    modelType: [
        {
            required: true,
            message: '请选择机型类别',
            trigger: ['blur', 'change']
        }
    ],
    flightNoIn: [
        {
            validator: (rule, value, callback) => {
                return value && /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '进港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ],
    flightNoOut: [
        {
            required: true,
            message: '请选择出港航班号',
            trigger: ['blur', 'change']
        },
        {
            validator: (rule, value, callback) => {
                return /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '出港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ]
})
export const formRef = ref()
//除冰弹框
export const deicingFlag = ref(false)
export const showDeicing = ref(false)
export const deicingFile = ref([])
//防冰弹框1
export const antiicingFlag = ref(false)
export const showAntiicing = ref(false)
export const antiicingFile = ref([])
//防冰弹框2
export const antiicing2Flag = ref(false)
export const showAntiicing2 = ref(false)
export const antiicing2File = ref([])
