import { upload } from 'mocp/utils/http'
import { canvasImage } from './sign.compositions'
import { formData } from './add.compositions'
import { addNonRoutineWorkApi, updateNonRoutineWorkApi } from 'mocp/api/electronicBill'
import Day from 'mocp/utils/dayjs'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        if (!canvasImage.value.includes('https')) {
            await uploadFile()
        }
        if (formData.id > 0) {
            await updateNonRoutineWork()
        } else {
            await addNonRoutineWork()
        }
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
//获取其他工具
export const getQtgj = (qtgj) => {
    //[{jh:abc,ts:1},{jh:abc,ts:2},{jh:abc,ts:3] => abc-1,abc-2,abc-3
    //判断是否数组
    if (Array.isArray(qtgj)) {
        return qtgj.map((item) => `${item.jh}-${item.ts}`).join(',')
    }
    if (typeof qtgj == 'string') {
        if (!qtgj) return []
        //abc-1,abc-2,abc-3 => [{jh:abc,ts:1},{jh:abc,ts:2},{jh:abc,ts:3]
        return qtgj.split(',').map((item) => {
            const [jh, ts] = item.split('-')
            return { jh, ts }
        })
    }
    return qtgj
}
export const addNonRoutineWork = async () => {
    const res = await addNonRoutineWorkApi({ ...formData, qtgj: getQtgj(formData.qtgj) }, { loading: true })
    if (res.code == 200) {
        uni.$emit('nonRoutineWorkReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const updateNonRoutineWork = async () => {
    const res = await updateNonRoutineWorkApi({ ...formData, qtgj: getQtgj(formData.qtgj) }, { loading: true })
    if (res.code == 200) {
        uni.$emit('nonRoutineWorkReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const resetData = () => {
    Object.assign(formData, {
        acreg: '',
        acu: undefined,
        aircaraftoperator: '',
        asu: undefined,
        bjjkzyxs: undefined,
        bjjkzyzk: undefined,
        bjscpxs: undefined,
        bjscpzk: undefined,
        cdydq: undefined,
        cgydq: undefined,
        charger: undefined,
        cherryPicker: undefined,
        cy: undefined,
        createTime: '',
        createUser: undefined,
        customerSignImg: '',
        customerSignTime: '',
        cyfdlgjcs: '',
        cyfdlgjjh: '',
        cydlgjcs: '',
        cydlgjjh: '',
        date: Day().valueOf(),
        fbjjkzyxs: undefined,
        fbjjkzyzk: undefined,
        fbjscpxs: undefined,
        fbjscpzk: undefined,
        flightNo: '',
        flightNoIn: '',
        flightNoOut: '',
        gjcl: undefined,
        gpu: undefined,
        hanger: undefined,
        hlgj: undefined,
        hy: undefined,
        id: 0,
        isDel: '',
        jackscrew: undefined,
        jgrygs: undefined,
        jgrygsHuors: undefined,
        jsjd: undefined,
        jsqjd: undefined,
        ladder: undefined,
        legs: '',
        legs1: '',
        legs2: '',
        legs3: '',
        gkgzt: undefined,
        lzqjd: undefined,
        material1: '',
        material2: '',
        material3: '',
        model: '',
        ndtktsbjh: '',
        ndtktsbts: undefined,
        ndtrygs: undefined,
        nickname: '',
        number1: undefined,
        number2: undefined,
        number3: undefined,
        oxygenCharging: undefined,
        powerTool: undefined,
        ptgzt: undefined,
        qtgj: [],
        qtxhp: undefined,
        shockStrutCharging: undefined,
        sjcptcc: undefined,
        sjcptcr: undefined,
        station: '',
        tails: undefined,
        tireCharging: undefined,
        tjpxs: undefined,
        tjpzk: undefined,
        tools: undefined,
        tractor: undefined,
        ttfj: undefined,
        updateTime: '',
        updateUser: undefined,
        username: '',
        work1: '',
        work2: '',
        work3: '',
        workingHours1: undefined,
        workingHours2: undefined,
        workingHours3: undefined,
        xbgkcc: undefined,
        xbgkcr: undefined,
        yyy: undefined
    })
}
