import { reactive } from 'vue'

export const formData = reactive({
    acreg: '',
    af: '0',
    airConditioning: undefined,
    airStarter: undefined,
    aircaraftoperator: '',
    customerSignImg: '',
    date: '',
    diversion: '0',
    flightNoIn: '',
    flightNoOut: '',
    groundPower: undefined,
    id: 0,
    legs: '',
    legs1: '',
    legs2: '',
    legs3: '',
    model: '',
    nickname: '',
    onCall: '0',
    others1: '',
    others2: '',
    pf: '0',
    remark: '',
    returnFlight: '0',
    serviceAf: '0',
    servicePf: '0',
    serviceTr: '0',
    station: '',
    towPus: undefined,
    tr: '0',
    username: '',
    routineInspection: '0',
    fly: '0',
    overnightAfPf: '0',
    upLocation: '',
    downLocation: ''
})

export const rules = reactive({
    station: [
        {
            required: true,
            message: '请选择航站',
            trigger: ['blur', 'change']
        }
    ],
    date: [
        {
            type: 'number',
            required: true,
            message: '请选择日期',
            trigger: ['blur', 'change']
        }
    ],
    acreg: [
        {
            required: true,
            message: '请选择机号',
            trigger: ['blur', 'change']
        }
    ],
    aircaraftoperator: [
        {
            required: true,
            message: '请选择飞机所属单位',
            trigger: ['blur', 'change']
        }
    ],
    model: [
        {
            required: true,
            message: '请选择机型',
            trigger: ['blur', 'change']
        }
    ],
    flightNoIn: [
        {
            required: true,
            message: '请选择进港航班号',
            trigger: ['blur', 'change']
        },
        {
            validator: (rule, value, callback) => {
                return /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '进港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ],
    flightNoOut: [
        {
            validator: (rule, value, callback) => {
                return value && /^[A-Z0-9]{2}\d{1,4}[A-Z]?$/.test(value)
            },
            message: '出港航班号格式错误',
            trigger: ['blur', 'change']
        }
    ],
    upLocation: [
        {
            validator: (rule, value, callback) => {
                return value && /^[A-Z0-9]+$/.test(value)
            },
            message: '起飞机位只能填写大写字母和数字',
            trigger: ['blur', 'change']
        }
    ],
    downLocation: [
        {
            validator: (rule, value, callback) => {
                return value && /^[A-Z0-9]+$/.test(value)
            },
            message: '落地机位只能填写大写字母和数字',
            trigger: ['blur', 'change']
        }
    ]
})
