import { upload } from 'mocp/utils/http'
import { canvasImage, showConfirm } from './sign.compositions'
import { formData } from './add.compositions'
import { addRoutineWorkApi, routineWorkCheckRepeatApi, updateRoutineWorkApi } from 'mocp/api/electronicBill'
import { timeStampFormat } from 'mocp/utils/tool'
import Day from 'mocp/utils/dayjs'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        if (!canvasImage.value.includes('https')) {
            await uploadFile()
        }
        if (formData.id > 0) {
            await updateRoutineWork()
        } else {
            await addRoutineWork()
        }
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const routineWorkCheckRepeat = async () => {
    0
    const params = {
        acreg: formData.acreg,
        date: timeStampFormat(formData.date, { format: 'YYYY-MM-DD' }),
        id: formData.id
    }
    const res = await routineWorkCheckRepeatApi(params, { loading: true })
    if (res.code == 200) {
        if (res.data > 0) {
            showConfirm.value = true
        } else {
            handleSubmit()
        }
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addRoutineWork = async () => {
    const res = await addRoutineWorkApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$emit('routineWorkReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const updateRoutineWork = async () => {
    const res = await updateRoutineWorkApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$emit('routineWorkReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const resetData = () => {
    showConfirm.value = false
    Object.assign(formData, {
        acreg: '',
        af: '0',
        airConditioning: undefined,
        airStarter: undefined,
        aircaraftoperator: '',
        customerSignImg: '',
        date: Day().valueOf(),
        diversion: '0',
        flightNoIn: '',
        flightNoOut: '',
        groundPower: undefined,
        id: 0,
        legs: '',
        legs1: '',
        legs2: '',
        legs3: '',
        model: '',
        nickname: '',
        onCall: '0',
        others1: '',
        others2: '',
        pf: '0',
        remark: '',
        returnFlight: '0',
        serviceAf: '0',
        servicePf: '0',
        serviceTr: '0',
        station: '',
        towPus: undefined,
        tr: '0',
        username: '',
        routineInspection: '0',
        fly: '0',
        overnightAfPf: '0',
        upLocation: '',
        downLocation: ''
    })
}
