import { previewFile } from 'mocp/utils/tool'

export const transformData = (data) => {
    return data.map((item) => {
        let type = item.name?.split('.')[1]?.toLowerCase() || 'unknown'
        if (item.directory) {
            type = 'folder'
        }
        return {
            ...item,
            type
        }
    })
}
export const handleClick = (item) => {
    if (item.directory) {
        uni.$mocpJump.navigateTo(`${'/panel/fileList/index?path=' + item.path}`)
    } else {
        previewFile(item.url)
    }
}
