import { dictData }  from './dictData.js'

export function getDictList(dict){
	return dictData.filter(r => r.type == dict);
}

// 获取字典编码对应名称
export function getDictName(dict, v) {
	if (!v) return '';
	const codeList = getDictList(dict);
	if (!codeList) return '';
	const o = codeList.find((r) => r.key == v);
	if (!o) return '';
	return o.value || '';
}

export function getPartOffReason() {
	return [{ value: '01', text: '实物件序号不详' }, { value: '02', text: '实物件序号系统不存在' }];
}

export function getPartOnReason() {
	return [{ value: '01', text: '从库房领出' }, { value: '02', text: '从飞机拆下' }];
}

export function getPartSnMode() {
	return [{ value: '1', text: '序控件' }, { value: '2', text: '非序控件' }];
}

export function getPartActivePassive() {
	return [{ value: '1', text: '主串' }, { value: '2', text: '被串' }];
}

export function getPartOb() {
	return [{ value: 'A', text: '不可用' }, { value: 'B', text: '可用' }, { value: 'C', text: '观察件' }];
}

// 获取字典编码列表对应名称列表，转字符串，逗号分割
// function getDictNames(dict: string, v?: string | string[]): string {
// 	if (!v) return '';
// 	const codeList = getDictList(dict);
// 	if (!codeList) return '';
// 	const vs = typeof (v) == 'string' ? v.split(',') : v;
// 	const list = codeList.filter((r: any) => vs.findIndex((_v) => _v == r.code) != -1);
// 	if (list.length == 0) return '';
// 	let lang = uni.getLocale();
// 	if (lang == 'zh-Hans') lang = 'zh';
// 	const names: string[] = [];
// 	list.forEach((r: any) => {
// 		if (r[lang]) names.push(r[lang]);
// 	})
// 	return names.join(',');
// }

// 获取字典编码列表对应名称列表
// function getDictNameList(dict: string, v?: string | string[]): string[] {
// 	if (!v) return [];
// 	const codeList = getDictList(dict);
// 	if (!codeList) return [];
// 	const vs = typeof (v) == 'string' ? v.split(',') : v;
// 	const list = codeList.filter((r: any) => vs.findIndex((_v) => _v == r.code) != -1);
// 	if (list.length == 0) return [];
// 	let lang = uni.getLocale();
// 	if (lang == 'zh-Hans') lang = 'zh';
// 	const names: string[] = [];
// 	list.forEach((r: any) => {
// 		if (r[lang]) names.push(r[lang]);
// 	})
// 	return names;
// }

//获取字典列表
// function getDictOption(dict: string, textField?: string): Option[] {
// 	const codeList = getDictList(dict);
// 	if (!codeList) return [];
// 	let lang = uni.getLocale();
// 	if (lang == 'zh-Hans') lang = 'zh';
// 	const arr: any[] = [];
// 	codeList.forEach((r: any) => {
// 		const v = { value: r.code, type: r.type };
// 		if (v[textField || 'text'] = r[lang]) arr.push(v);
// 	})
// 	return arr;
// }

//获取字典映射
// function getDictMap(dict: string): any {
// 	const codeList = getDictList(dict);
// 	if (!codeList) return [];
// 	let lang = uni.getLocale();
// 	if (lang == 'zh-Hans') lang = 'zh';
// 	const map = {};
// 	codeList.forEach((r: any) => {
// 		map[r.code] = r[lang] || '';
// 	})
// 	return map;
// }

// 获取字典项
// function getDictItem(dict: string, code: string): Dict | undefined {
// 	if (!dict || !code) return null;
// 	const codeList = getDictList(dict);
// 	if (!codeList) return null;
// 	return codeList.find((r: Dict) => r.code == code);
// }
