import {
	request123
} from '@/utils/request.js'

export function AssessmentPageAPi(planNo, username, dataid) {
	return request123({
		url: '/QuestionManagement/queryAssessmentPage',
		data: {
			planNo,
			username,
			dataid
		},
		method: 'GET',
	})
}
export function submitAssessment(data) {
	return request123({
		url: '/QuestionManagement/submitAssessment',
		data,
		method: 'post'
	})
}
export function getUserValidate(ticket) {
	return request123({
		url: '/api/train/sys/checkToken',
		data:{
			ticket
		},
		method: 'GET'
	})
}
export function getExamUserToken() {
	return request123({
		url: '/examApp/getExamUserToken',
		method: 'get'
	})
}
// 登录接口
export const login = data => {
	let time = data.time
	return request123({
		url: '/sys/login',
		method: 'POST',
		data: data
	})
}


// 图片接口 sys/randomImage/1684720796409   1684720884595
export const loginImg = data => {
	let time = data.time
	return request123({
		url: '/sys/randomImage/' + time,
		method: 'GET',
		data: data
	})
}

// 考试中心
export const examinationCenter = data => {
	return request123({
		url: '/UsersExamination/getExamsCount',
		method: 'POST',
		data: data,
	})
}

// 考试列表
export const getExamList = data => {
	return request123({
		url: '/UsersExamination/getExamsList',
		method: 'POST',
		data: data,
	})
}
// 考试分析
export const examinationAnalysis = data => {
	return request123({
		url: '/UsersExamination/getExamsAnalysis',
		method: 'POST',
		data: data,
	})
}