//配置公共方法
// import common from "./utils/common.js"
import { createSSRApp } from "vue";
import App from "./App.vue";
import Vuex from "vuex";
import pinia from "mocp/store";
import uviewPlus, { setConfig } from "uview-plus";
import * as message from "mocp/utils/message";
import * as tool from "mocp/utils/tool";
import * as jump from "mocp/utils/jump";
// @ts-ignore
// import {store} from "./pages/modules/mocp/src/vuex/entry"
// amms原生
import cuCustom from "./colorui/components/cu-custom.vue";
import qLoading from "./components/qLoading.vue";
import qSteps from "./components/qSteps.vue";
import qSuccess from "./components/qSuccess.vue";
import qTab from "./components/qTab.vue";
import qModal from "./components/qModal.vue";
import wPicker from "./components/w-picker/w-picker.vue";
import lDrag from "./uni_modules/lime-drag/components/l-drag/l-drag.vue";
import uniDataCheckbox from "./uni_modules/uni-data-checkbox/components/uni-data-checkbox/uni-data-checkbox.vue";
import uniTransition from "./uni_modules/uni-transition/uni-transition.vue";
import uniIcons from "./uni_modules/uni-icons/components/uni-icons/uni-icons.vue";
import zSwiper from "./uni_modules/zebra-swiper/components/z-swiper/z-swiper.vue";
import zSwiperItem from "./uni_modules/zebra-swiper/components/z-swiper-item/z-swiper-item.vue";
import uniIndexedList from "./uni_modules/uni-indexed-list/components/uni-indexed-list/uni-indexed-list.vue";
import uniIndexedListItem from "./uni_modules/uni-indexed-list/components/uni-indexed-list/uni-indexed-list-item.vue";
import uniSearchBar from "./uni_modules/uni-search-bar/components/uni-search-bar/uni-search-bar.vue";
import uniNavBar from "./uni_modules/uni-nav-bar/components/uni-nav-bar/uni-nav-bar.vue";
import uniStatusBar from "./uni_modules/uni-nav-bar/components/uni-nav-bar/uni-status-bar.vue";
import uniRow from "./uni_modules/uni-row/components/uni-row/uni-row.vue";
import uniCol from "./uni_modules/uni-row/components/uni-col/uni-col.vue";
import uniDrawer from "./uni_modules/uni-drawer/uni-drawer.vue";
import uniPopup from "./uni_modules/uni-popup/uni-popup.vue";
import uniPopupMessage from "./uni_modules/uni-popup/uni-popup-message.vue";
import uniSegmentedControl from "./uni_modules/uni-segmented-control/components/uni-segmented-control/uni-segmented-control.vue";
import uniCollapse from "./uni_modules/uni-collapse/uni-collapse.vue";
import uniCollapseItem from "./uni_modules/uni-collapse-item/uni-collapse-item.vue";
import uniLoadMore from "./uni_modules/uni-load-more/components/uni-load-more/uni-load-more.vue";
import uniEasyinput from "./uni_modules/uni-easyinput/components/uni-easyinput/uni-easyinput.vue";
import uniForms from "./uni_modules/uni-forms/components/uni-forms/uni-forms.vue";
import uniFormsItem from "./uni_modules/uni-forms/components/uni-forms-item/uni-forms-item.vue";
import uniDatetimePicker from "./uni_modules/uni-datetime-picker/components/uni-datetime-picker/uni-datetime-picker.vue";
import uniCombox from "./uni_modules/uni-combox/components/uni-combox/uni-combox.vue";
import uniDataSelect from "./uni_modules/uni-data-select/components/uni-data-select/uni-data-select.vue";
import dashboardCssV from "./uni_modules/dashboard-css-v/components/dashboard-css-v/dashboard-css-v.vue";
import uniCard from "./uni_modules/uni-card/components/uni-card/uni-card.vue";
import uniFilePicker from "./uni_modules/uni-file-picker/components/uni-file-picker/uni-file-picker.vue";
import imageUpload from "./components/image-upload/image-upload.vue";
import uniTable from "./uni_modules/uni-table/components/uni-table/uni-table.vue";
import uniTbody from "./uni_modules/uni-table/components/uni-tbody/uni-tbody.vue";
import uniTd from "./uni_modules/uni-table/components/uni-td/uni-td.vue";
import uniTh from "./uni_modules/uni-table/components/uni-th/uni-th.vue";
import uniThead from "./uni_modules/uni-table/components/uni-thead/uni-thead.vue";
import uniTr from "./uni_modules/uni-table/components/uni-tr/uni-tr.vue";
import selectCy from "./uni_modules/select-cy/components/select-cy/select-cy.vue";
import uniPagination from "./uni_modules/uni-pagination/components/uni-pagination/uni-pagination.vue";
import ccSelectDity from "./uni_modules/cc-selectDity/components/cc-selectDity/cc-selectDity.vue";

//mocp消息提示
uni.$mocpMessage = message;
//mocp工具方法
uni.$mocpTool = tool;
//mocp页面跳转
uni.$mocpJump = jump;
export function createApp() {
  const app = createSSRApp(App);
  app.component("cu-custom", cuCustom);
  app.component("q-loading", qLoading);
  app.component("q-steps", qSteps);
  app.component("q-success", qSuccess);
  app.component("q-tab", qTab);
  app.component("q-modal", qModal);
  app.component("l-drag", lDrag);
  app.component("uni-data-checkbox", uniDataCheckbox);
  app.component("uni-transition", uniTransition);
  app.component("uni-icons", uniIcons);
  app.component("z-swiper", zSwiper);
  app.component("z-swiper-item", zSwiperItem);
  app.component("w-picker", wPicker);
  app.component("uni-indexed-list", uniIndexedList);
  app.component("uni-indexed-list-item", uniIndexedListItem);
  app.component("uni-search-bar", uniSearchBar);
  app.component("uni-nav-bar", uniNavBar);
  app.component("uni-status-bar", uniStatusBar);
  app.component("uni-row", uniRow);
  app.component("uni-col", uniCol);
  app.component("uni-drawer", uniDrawer);
  app.component("uni-popup", uniPopup);
  app.component("uni-segmented-control", uniSegmentedControl);
  app.component("uni-collapse", uniCollapse);
  app.component("uni-collapse-item", uniCollapseItem);
  app.component("uni-load-more", uniLoadMore);
  app.component("uni-easyinput", uniEasyinput);
  app.component("uni-forms", uniForms);
  app.component("uni-forms-item", uniFormsItem);
  app.component("uni-datetime-picker", uniDatetimePicker);
  app.component("uni-combox", uniCombox);
  app.component("uni-data-select", uniDataSelect);
  app.component("dashboard-css-v", dashboardCssV);
  app.component("uni-card", uniCard);
  app.component("uni-popup-message", uniPopupMessage);
  app.component("uni-file-picker", uniFilePicker);
  app.component("image-upload", imageUpload);
  app.component("select-cy", selectCy);
  app.component("uni-table", uniTable);
  app.component("uni-tbody", uniTbody);
  app.component("uni-td", uniTd);
  app.component("uni-th", uniTh);
  app.component("uni-thead", uniThead);
  app.component("uni-tr", uniTr);
  app.component("uni-pagination", uniPagination);
  app.component("cc-selectDity", ccSelectDity);
  // app.use(store)
  uni.getSystemInfo({
    success: function (e) {
      app.config.globalProperties.StatusBar = e.statusBarHeight;
      app.provide("statusBarHeight", e.statusBarHeight);
      // #ifndef MP
      app.config.globalProperties.CustomBar = e.statusBarHeight + 50;
      app.provide("CustomBar", e.statusBarHeight + 50);
      // #endif
      // h5 app mp-alipay不支持微信的方法
      // #ifndef H5 || APP-PLUS || MP-ALIPAY
      // 获取胶囊位置,API getMenuButtonBoundingClientRect 只有在微信小程序运行的时候才会生效，H5端查看会报错
      let custom = wx.getMenuButtonBoundingClientRect();
      app.config.globalProperties.Custom = custom;
      app.config.globalProperties.CustomBar =
        custom.bottom + custom.top - e.statusBarHeight;
      // #endif

      app.config.globalProperties.StatusBar = e.statusBarHeight;

      // #ifdef MP-ALIPAY
      app.config.globalProperties.CustomBar =
        e.statusBarHeight + e.titleBarHeight;
      // #endif
    },
  });
  // app.mount('#app')
  app.use(pinia);
  app.use(uviewPlus);
  setConfig({
    props: {
      checkbox: {
        activeColor: "#165dff",
        labelColor: "#1D2129",
        labelSize: 16,
      },
      checkboxGroup: {
        activeColor: "#165dff",
        labelColor: "#1D2129",
        labelSize: 16,
      },
      radio: {
        activeColor: "#165dff",
        labelColor: "#1D2129",
        labelSize: 16,
      },
      radioGroup: {
        activeColor: "#165dff",
        labelColor: "#1D2129",
        labelSize: 16,
      },
      cell: {
        titleStyle: {
          color: "#1D2129",
        },
      },
      input: {
        placeholderStyle: "fontSize: 28rpx",
      },
    },
  });
  return {
    app,
    Vuex,
  };
}

// createApp();
