import { defineStore } from 'pinia'

const useSupportApplicationStore = defineStore('supportApplication', {
    state: () => {
        return {
            searchData: {
                state: '',
                machineNumber: '',
                model: '',
                aviation: '',
                terminal: '',
                specialty: '',
                engineModel: ''
            },
            details: undefined
        }
    },
    getters: {},
    actions: {
        resetForm() {
            this.searchData = {
                state: '',
                machineNumber: '',
                model: '',
                aviation: '',
                terminal: '',
                specialty: '',
                engineModel: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useSupportApplicationStore
