import { reactive, ref } from 'vue'
export const fileVoList = ref([]) //分解计划文件
export const approvalFileVoList = ref([]) //工作反馈文件
export const formData = reactive({
    problem: '',
    workTarget: '',
    current: '',
    baseApprovalLeader: '',
    mcdApprovalLeader: '',
    followUpFeedback: '0',
    pcTime: null,
    feedbackState: null,
    feedbackUser: '',
    feedbackTime: '',
    approvalFile: '',
    file: ''
})
export const rules = reactive({
    feedbackState: [
        {
            type: 'number',
            required: true,
            message: '请选择工作反馈状态',
            trigger: ['blur', 'change']
        }
    ],
    problem: [
        {
            required: true,
            message: '请输入问题分析',
            trigger: ['blur', 'change']
        }
    ],
    workTarget: [
        {
            required: true,
            message: '请输入解决措施',
            trigger: ['blur', 'change']
        }
    ],
    current: [
        {
            required: true,
            message: '请输入当前进展',
            trigger: ['blur', 'change']
        }
    ],
    baseApprovalLeader: [
        {
            required: true,
            message: '请输入基地/部门批准领导',
            trigger: ['blur', 'change']
        }
    ],
    mcdApprovalLeader: [
        {
            required: true,
            message: 'MCD批准领导',
            trigger: ['blur', 'change']
        }
    ],
    followUpFeedback: [
        {
            required: true,
            message: '请选择后续措施反馈',
            trigger: ['blur', 'change']
        }
    ],
    pcTime: [
        {
            type: 'number',
            required: true,
            message: '请选择计划完成时间',
            trigger: ['blur', 'change']
        }
    ]
})
