 async function compressImage(src, platform) {
	const imageInfo = await getImageInfo(src);
	const orientation = imageInfo.orientation;
	let rotate = 0;
	let quality = 70;
	if (platform === 'ios') {
		rotate = 0;
		quality = 25;
	} else {
		switch (orientation) {
			case 'up': //exif:1 不旋转
				rotate = 0;
				break;
			case 'down': //exif:3 旋转180度
				rotate = 180;
				break;
			case 'right': //exif:6 旋转90度
				rotate = 90;
				break;
			case 'left': //exif:8 旋转270度
				rotate = 270;
				break;
			default:
				rotate = 0;
				break;
		}
	}
	return new Promise(function(resolve, reject) {
        if (typeof(plus) != 'undefined') {
            plus.zip.compressImage({
            		src: src,
            		dst: "_doc/uniapp_temp" + '/compressed/' + Math.round(new Date()) + '.jpg',
            		format: 'jpg',
            		quality: quality,
            		width: 'auto',
            		height: 'auto',
            		rotate: rotate,
            	},
            	function(event) {
            		let tempPath = event.target;
            		resolve(tempPath)
            	},
            	function(error) {
            		reject(error);
            	});
        } else {
            resolve(src)
            // let canvasWidth = imageInfo.width //图片原始长宽
            // let canvasHeight = imageInfo.height
            // let img = new Image()
            // img.src = src
            // let canvas = document.createElement('canvas');
            // canvas.width = canvasWidth / 4
            // canvas.height = canvasHeight / 4
            // console.log(33)
            // let ctx = canvas.getContext('2d')
            // ctx.drawImage(img, 0, 0, canvasWidth / 4, canvasHeight / 4)
            // console.log(ctx)
            // console.log(src)
            // setTimeout(() => {
            //     canvas.toBlob((fileSrc) => {
            //         let imgSrc = window.URL.createObjectURL(fileSrc)
            //     	console.log('压缩后', window.URL.createObjectURL(fileSrc))
            //     	resolve(imgSrc)
            //     }, 'image/jpeg')
            // }, 600)
        }
		
	})
}
 
function getImageInfo(path) {
	return new Promise(function(resolve, reject) {
		if (typeof(plus) != 'undefined') {
            plus.io.getImageInfo({
            	src: path,
            	success: function(image) {
            		// console.log(image.width);
            		// console.log(image.height);
            		// console.log('orientation=' + image.orientation);
            		// console.log('path=' + image.path);
            		resolve(image)
            	},
            	fail: function(err) {
            		console.log("getImageInfoErr: " + JSON.stringify(err));
            		reject(err)
            	}
            });
        } else {
            uni.getImageInfo({
            	src: path,
            	success: function(image) {
            		// console.log(image.width);
            		// console.log(image.height);
            		// console.log('orientation=' + image.orientation);
            		// console.log('path=' + image.path);
            		resolve(image)
            	},
            	fail: function(err) {
            		console.log("getImageInfoErr: " + JSON.stringify(err));
            		reject(err)
            	}
            });
        }
	});
}
 
export default compressImage