import { defineStore } from 'pinia'

const useMoveDecisionStore = defineStore('moveDecision', {
    state: () => {
        return {
            searchData: {
                state: 1,
                presenter: '',
                seat: '',
                workType: null,
                startDateTime: null,
                endDateTime: null
            },
            details: undefined
        }
    },
    getters: {
        getFileList(state) {
            return state.details?.file ? JSON.parse(state.details?.file) : []
        }
    },
    actions: {
        resetForm() {
            this.searchData = {
                state: 1,
                presenter: '',
                seat: '',
                workType: null,
                startDateTime: null,
                endDateTime: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMoveDecisionStore
