import { getRsData2Api } from 'mocp/api/operationalSurvey'
import { defineStore } from 'pinia'

const useOperationalSurveyStore = defineStore('operationalSurvey', {
    state: () => {
        return {
            selectList: {
                allSeatSelect: []
            },
            searchData: {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                startTime: null,
                stopTime: null,
                seat: ''
            },
            workbenchId: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getRsData2() {
            const res = await getRsData2Api({ workbenchId: this.workbenchId }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                startTime: null,
                stopTime: null,
                seat: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useOperationalSurveyStore
