import { getEnetOrgTreeApi } from 'mocp/api/assign-work'
import { getQaData2Api, getQaDimensionTree2Api } from 'mocp/api/qualityAnalysis'
import { defineStore } from 'pinia'

function findRelatedLabelOfEnetOrg(items, id) {
    let res = ''
    for (const item of items) {
        if (item.key == id) {
            res = item.label
            break
        }
        if (Array.isArray(item.children)) {
            res = findRelatedLabelOfEnetOrg(item.children, id)
            if (res) {
                break
            }
        }
    }
    return res
}
const useQualityAnalysisStore = defineStore('qualityAnalysis', {
    state: () => {
        return {
            selectList: {
                allSeatSelect: [],
                dimensionTree: [],
                EnetOrgTree: [],
                EnetOrgRepeatTree: [],
                EnetOrgRepeatTreeZh: []
            },
            searchData: {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                dimension1: '',
                liabilityBelong: '',
                eventMsg: ''
            },
            workbenchId: '',
            details: undefined
        }
    },
    getters: {
        getDimension1() {
            return this.selectList.dimensionTree.map((v) => {
                return {
                    label: v.label,
                    value: v.label
                }
            })
        }
    },
    actions: {
        async getQaDimensionTree2() {
            const res = await getQaDimensionTree2Api({})
            if (res.code == 200) {
                let arr = res.data.map((v) => {
                    let arr1 = v.subDimensionList.map((e) => {
                        let arr2 = e.subDimensionList.map((j) => {
                            return {
                                label: j.name,
                                key: j.name,
                                eventclass1: v.name,
                                eventclass2: e.name,
                                eventclass3: j.name
                            }
                        })
                        return {
                            label: e.name,
                            key: e.name,
                            eventclass1: v.name,
                            eventclass2: e.name,
                            children: arr2
                        }
                    })
                    return {
                        label: v.name,
                        key: v.name,
                        eventclass1: v.name,
                        eventclass2: '',
                        children: arr1
                    }
                })
                this.selectList.dimensionTree = arr || []
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        async getQaData2() {
            const res = await getQaData2Api({ workbenchId: this.workbenchId })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        async getEnetOrgTree() {
            const res = await getEnetOrgTreeApi({})
            if (res.code == 200) {
                function transformData(data) {
                    return data.map((v) => {
                        let arr = []
                        if (v.nodeList.length) {
                            arr = transformData(v.nodeList)
                        }
                        return {
                            label: v.fullName,
                            key: v.nodeId + v.level,
                            id: v.nodeId,
                            children: arr
                        }
                    })
                }
                this.selectList.EnetOrgTree = transformData(res.data)
                function transformRepeatData(data) {
                    return data.map((v) => {
                        let arr = []
                        if (v.nodeList.length) {
                            arr = transformRepeatData(v.nodeList)
                        }
                        return {
                            label: v.fullName,
                            key: v.nodeId,
                            id: v.nodeId,
                            children: arr
                        }
                    })
                }
                this.selectList.EnetOrgRepeatTree = transformRepeatData(res.data)
                function transformRepeatDataZh(data) {
                    return data.map((v) => {
                        let arr = []
                        if (v.nodeList.length) {
                            arr = transformRepeatDataZh(v.nodeList)
                        }
                        return {
                            label: v.fullName,
                            key: v.fullName,
                            id: v.fullName,
                            children: arr
                        }
                    })
                }
                this.selectList.EnetOrgRepeatTreeZh = transformRepeatDataZh(res.data)
            }
        },
        getEnetRepeatOrg(id) {
            return findRelatedLabelOfEnetOrg(this.selectList.EnetOrgRepeatTree, id)
        },
        getEnetOrg(id) {
            return findRelatedLabelOfEnetOrg(this.selectList.EnetOrgTree, id)
        },
        resetForm() {
            this.searchData = {
                isOpen: 1,
                acTerminal: '',
                acOwn: '',
                acType: '',
                ac: '',
                dimension1: '',
                liabilityBelong: '',
                eventMsg: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useQualityAnalysisStore
