const getQueryString = (params = {}) => {
    return Object.keys(params)
        .map((key) => `${encodeURIComponent(key)}=${encodeURIComponent(params[key])}`)
        .join('&')
}

/**
 * 封装 uni.navigateTo 为 Promise 版本
 * @param {string} url 要跳转的页面路径
 * @param {Object} params 要传递的参数对象
 * @returns {Promise} 返回一个 Promise 对象，resolve 表示跳转成功，reject 表示跳转失败
 */
export const navigateTo = (url, params = {}) => {
    return new Promise((resolve, reject) => {
        // 将参数对象转换为查询字符串
        const queryString = getQueryString(params)
        // 拼接完整的 URL
        const fullUrl = queryString ? `${url}?${queryString}` : url
        // 调用 uni.navigateTo 并处理结果
        uni.navigateTo({
            url: '/pages/modules/mocp' + fullUrl,
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        })
    })
}

/**
 * 封装 uni.redirectTo 为 Promise 版本
 * @param {string} url 要跳转的页面路径
 * @param {Object} params 要传递的参数对象
 * @returns {Promise} 返回一个 Promise 对象，resolve 表示跳转成功，reject 表示跳转失败
 */
export const redirectTo = (url, params = {}) => {
    return new Promise((resolve, reject) => {
        // 将参数对象转换为查询字符串
        const queryString = getQueryString(params)
        // 拼接完整的 URL
        const fullUrl = queryString ? `${url}?${queryString}` : url
        // 调用 uni.redirectTo 并处理结果
        uni.redirectTo({
            url: '/pages/modules/mocp' + fullUrl,
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        })
    })
}

/**
 * 封装 uni.reLaunch 为 Promise 版本
 * @param {string} url 要跳转的页面路径
 * @param {Object} params 要传递的参数对象
 * @returns {Promise} 返回一个 Promise 对象，resolve 表示跳转成功，reject 表示跳转失败
 */
export const reLaunch = (url, params = {}) => {
    return new Promise((resolve, reject) => {
        // 将参数对象转换为查询字符串
        const queryString = getQueryString(params)
        // 拼接完整的 URL
        const fullUrl = queryString ? `${url}?${queryString}` : url
        // 调用 uni.reLaunch 并处理结果
        uni.reLaunch({
            url: '/pages/modules/mocp' + fullUrl,
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        })
    })
}

/**
 * 封装 uni.navigateBack 为 Promise 版本
 * @param {string} delta 要回退的数量
 * @returns {Promise} 返回一个 Promise 对象，resolve 表示跳转成功，reject 表示跳转失败
 */
export const navigateBack = (delta = 1) => {
    return new Promise((resolve, reject) => {
        // 调用 uni.navigateBack 并处理结果
        uni.navigateBack({
            delta,
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        })
    })
}

/**
 * 封装 uni.switchTab 为 Promise 版本
 * @param {string} name 要跳转的tab页面名称
 * @returns {Promise} 返回一个 Promise 对象，resolve 表示跳转成功，reject 表示跳转失败
 */
export const switchTab = (name) => {
    return new Promise((resolve, reject) => {
        // 调用 uni.redirectTo 并处理结果
        const fullUrl = 'tab/index?name=' + name
        uni.redirectTo({
            url: '/pages/modules/mocp' + fullUrl,
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        })
    })
}
