import { getSurveyTemplateDetailApi } from 'mocp/api/workSupervision'
import { formData, templateDetail } from './answerQuestion.compositions'

export const getSurveyTemplateDetail = async (templateId) => {
    //清空内容
    templateDetail.value = undefined
    formData.value = []
    const res = await getSurveyTemplateDetailApi({ templateId }, { loading: true })
    if (res.code == 200) {
        templateDetail.value = res.data
        formData.value = res.data?.questionList.map((item) => {
            //选项
            const quRadioList = item.quRadioList.map((option) => {
                return {
                    ...option,
                    value: undefined
                }
            })
            //多选填空输入框
            const inputList = []
            item.quName?.split('##{input}##').forEach((option) => {
                if (option && item.quType == '5') {
                    inputList.push({ value: '' })
                }
            })
            return {
                ...item,
                quRadioList,
                inputList,
                value: undefined
            }
        })
    } else {
        uni.$mocpMessage.error(res.message)
    }
}

export const getParams = ({ templateId, belongId: belongTaskId }) => {
    const anAttaList = [] //附件题答案
    const anFillblankList = [] //填空题答案
    const anRadioList = [] //单选题/多选题/判断题/下拉框答案
    const anTimeList = [] //时间题型答案
    formData.value.forEach((item) => {
        // 附件题答案
        if (item.quType == '3') {
            anAttaList.push({
                templateId,
                belongTaskId,
                quId: item.id,
                atta: item.value
            })
        }
        // 填空题答案
        if (item.quType == '0') {
            anFillblankList.push({
                templateId,
                belongTaskId,
                quId: item.id,
                answer: item.value
            })
        }
        if (item.quType == '5') {
            anFillblankList.push({
                templateId,
                belongTaskId,
                quId: item.id,
                answer: item.inputList.map((option) => option.value).join(',')
            })
        }
        // 单选题/判断题/多选题/下拉框答案
        if (item.quType == '1' || item.quType == '2' || item.quType == '4' || item.quType == '7') {
            const quItemId = item.quType == '4' ? item.value.join(',') : item.value
            const content = item.quRadioList
                .filter((option) => item.value?.includes(option.id) && option.isFillblank == '1')
                .map((option) => {
                    return {
                        id: option.id,
                        content: option.value || ''
                    }
                })
            if (content.length) {
                anRadioList.push({
                    templateId,
                    belongTaskId,
                    quId: item.id,
                    quItemId,
                    content
                })
            } else {
                anRadioList.push({
                    templateId,
                    belongTaskId,
                    quId: item.id,
                    quItemId
                })
            }
        }
        // 时间题型答案
        if (item.quType == '6') {
            anTimeList.push({
                templateId,
                belongTaskId,
                quId: item.id,
                answer: item.value
            })
        }
    })
    return {
        anAttaList: JSON.stringify(anAttaList),
        anFillblankList: JSON.stringify(anFillblankList),
        anRadioList: JSON.stringify(anRadioList),
        anTimeList: JSON.stringify(anTimeList),
        repairTaskInfoId: belongTaskId
    }
}
