import * as dictData from './dict-data'
import { cloneDeep } from 'lodash'

export function useDict(dictkey, opt) {
    if (!dictkey && !opt?.data) {
        return []
    }
    let currentDictList = cloneDeep((opt?.data ? opt.data : (dictData)[dictkey] || []))
    if (opt?.filter) {
        currentDictList = currentDictList.filter((item) => {
            return opt.filter && opt.filter(item)
        })
    }
    return currentDictList
}

export function useGetDictByLabel(dictkey, label, option) {
    const enterSplit = option?.enterSplit || ','
    const outputSplit = option?.enterSplit || '；'
    const labelArr = label.split(enterSplit)
    const values = []
    useDict(dictkey, { filter: option?.filter, data: option?.data }).forEach((item) => {
        if (
            labelArr.some((label) => {
                return label == item['label']
            })
        ) {
            values.push(item['value'])
        }
    })
    return values.join(outputSplit)
}

export function useGetDictByValue(dictkey, value = '', option) {
    const enterSplit = option?.enterSplit || ','
    const outputSplit = option?.enterSplit || '；'
    const valueArr = String(value).split(enterSplit)
    const labels = []
    useDict(dictkey, { filter: option?.filter, data: option?.data }).forEach((item) => {
        if (
            valueArr.some((value) => {
                return value == String(item['value'])
            })
        ) {
            labels.push(item['label'])
        }
    })
    return labels.join(outputSplit)
}

export function useGetDictByProp(dictkey, value = '', prop, option) {
    const enterSplit = option?.enterSplit || ','
    const outputSplit = option?.enterSplit || '；'
    const valueArr = String(value).split(enterSplit)
    const labels = []
    useDict(dictkey, { filter: option?.filter, data: option?.data }).forEach((item) => {
        if (
            valueArr.some((value) => {
                return value == String(item['value'])
            })
        ) {
            labels.push(item[prop])
        }
    })
    return labels.join(outputSplit)
}
