import { getDutyLogDetailApi } from 'mocp/api/dutyLog'
import { defineStore } from 'pinia'

const useDutyLogStore = defineStore('dutyLog', {
    state: () => {
        return {
            searchData: {
                dutyManagerUname: '',
                monitorLeaderUname: '',
                statusStr: '',
                dutyDateE: null,
                dutyDateS: null
            },
            id: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getDetails() {
            this.details = undefined
            const res = await getDutyLogDetailApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                dutyManagerUname: '',
                monitorLeaderUname: '',
                statusStr: '',
                dutyDateE: null,
                dutyDateS: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useDutyLogStore
