import { getAcReduceListApi } from 'mocp/api/system'
import { correctiveAttaFileVoList, formData, surveyAttaFileVoList } from './edit.compositions'

//切换机号
export const changeAc = async () => {
    const res = await getAcReduceListApi({ ac: formData.machineNumber }, { loading: true })
    if (res.code == 200) {
        formData.model = res.data[0]?.zstortgc
        formData.aviation = res.data[0]?.zop3
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const getSurveyAttaFileVoList = (value) => {
    surveyAttaFileVoList.value = value
}
export const getCorrectiveAtta = (value) => {
    correctiveAttaFileVoList.value = value
}
export const resetData = () => {
    surveyAttaFileVoList.value = []
    correctiveAttaFileVoList.value = []
    Object.assign(formData, {
        source: '',
        terminalCode: '',
        repairUnit: '',
        personLiable: '',
        machineNumber: '',
        model: '',
        aviation: '',
        eventDescription: '',
        problemPoints: '',
        category: '',
        pointsDeduction: null,
        occurrenceTime: null,
        surveyUnit: '',
        eventProperty: '',
        remake: '',
        survey: '',
        surveyAtta: '',
        surveyAttaFileVoList: [],
        surveyTimeLimit: null,
        surveyFeedback: '',
        correctiveComplete: '',
        correctiveAtta: '',
        correctiveAttaFileVoList: [],
        correctiveTimeLimit: null,
        correctiveComplete: '',
        correctiveMeasures: '',
        delay: ''
    })
}
