import { addUnplanApplyApi, checkPakgeNoApi } from 'mocp/api/unplanApply'
import { formData, formRef, materialPns } from './add.compositions'

export const resetData = () => {
    materialPns.value = ['']
    Object.assign(formData, {
        packageNo: '',
        delayDay: '',
        approver: '',
        warningReason: '',
        materialDelay: '0',
        materialPns: '',
        reason: '',
        delayDay: null
    })
}

//验证包号
export const checkPakgeNo = async (packageNo) => {
    if (!packageNo) return
    const res = await checkPakgeNoApi({ packageNo }, { loading: '验证包号中...' })
    if (res.code == 200) {
    } else {
        formData.packageNo = ''
        uni.$mocpMessage.error(res.message)
    }
}

export const addMaterialPns = () => {
    if (materialPns.value.length >= 10) return uni.$mocpMessage.warning('缺件航材最多填写10个')
    materialPns.value.push('')
}

//提交表单
export const handleSubmit = async () => {
    await formRef.value?.validate()
    if (formData.materialDelay == '0') {
        formData.materialPns = ''
    } else {
        const materialPnsStr = materialPns.value.join(',')
        if (materialPnsStr) {
            formData.materialPns = materialPnsStr
        } else {
            return uni.$mocpMessage.error('请输入缺件航材')
        }
    }
    const res = await addUnplanApplyApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        uni.$mocpMessage.success(res.message)
        uni.$emit('unplanApplyReload')
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
