import { getArrangeWorkDetailApi, getEnetOrgTreeApi, getSeatUnitApi } from 'mocp/api/assign-work'
import { defineStore } from 'pinia'
import useUserStore from 'mocp/store/user'

const arrangeWorkExtendRouter = [
    { name: '工作反馈', path: '/panel/assign-work/edit-work' },
    { name: '领导批示', path: '/panel/assign-work/edit-approval' },
    { name: '跟踪反馈', path: '/panel/assign-work/edit-gzFeedback' },
    { name: '跟踪批示', path: '/panel/assign-work/edit-gzApproval' },
    { name: '后续措施反馈', path: '/panel/assign-work/edit-followUpFeedback' },
    { name: '工作验证', path: '/panel/assign-work/edit-validate' }
]
const useAssignWorkStore = defineStore('assignWork', {
    state: () => {
        return {
            searchData: {
                state: null,
                presenter: '',
                seat: '',
                workType: 1,
                startTime: null,
                stopTime: null
            },
            id: '',
            details: undefined,
            arrangeWorkExtendList: [], //责任单位列表
            arrangeWorkExtend: undefined, //当前选中的责任单位
            selectList: {
                seatList: [], //管理席位
                EnetOrgTree: [] //获取易网部门树形列表
            }
        }
    },
    getters: {
        getSeatUnitSelect(state) {
            return state.selectList.seatList.map((q) => ({
                label: q.adminSeat,
                value: q.adminSeat
            }))
        },
        //获取当前选中的责任单位的index
        getArrangeWorkExtendIndex(state) {
            return state.arrangeWorkExtendList.findIndex((item) => item.id == state.arrangeWorkExtend.id)
        },
        //是否创建人
        isCreateUser(state) {
            const userStore = useUserStore()
            return state.details.createUserId == userStore.userInfo.id
        },
        //是否回复人
        isReplyUser(state) {
            const userStore = useUserStore()
            if (state.details.reply) {
                const replyIds = JSON.parse(state.details.reply)[this.getArrangeWorkExtendIndex].map((item) => item.userId)
                return replyIds.includes(userStore.userInfo.id)
            } else {
                return false
            }
        },
        //是否领导
        isPresenterUser(state) {
            const userStore = useUserStore()
            if (state.details.presenterId) {
                return state.details.presenterId.split(',').includes(userStore.userInfo.id)
            }
            return false
        },
        //获取分解计划
        getDecompose(state) {
            return JSON.parse(state.arrangeWorkExtend?.decompose || '[]') || []
        },
        //获取详情页底部按钮的内容
        getDetailsFooterBtn(state) {
            if (!state.arrangeWorkExtend) return false
            if (state.arrangeWorkExtend.feedbackTime == '0') {
                if (this.isReplyUser) {
                    return arrangeWorkExtendRouter[0]
                }
            } else {
                if (state.arrangeWorkExtend.approvalTime == '0') {
                    if (this.isPresenterUser) {
                        return arrangeWorkExtendRouter[1]
                    }
                } else {
                    if (state.arrangeWorkExtend.gzFeedbackTime == '0') {
                        if (this.isReplyUser && state.arrangeWorkExtend.leaderState != '' && state.arrangeWorkExtend.leaderState != '1') {
                            return arrangeWorkExtendRouter[2]
                        }
                    } else {
                        if (state.arrangeWorkExtend.gzApprovalTime == '0') {
                            if (this.isPresenterUser && state.arrangeWorkExtend.leaderState != '' && state.arrangeWorkExtend.leaderState != '1') {
                                return arrangeWorkExtendRouter[3]
                            }
                        } else {
                            if (state.arrangeWorkExtend.followUpFeedbackTime == '0') {
                                if (this.isReplyUser && state.arrangeWorkExtend.followUpFeedback == '1') {
                                    return arrangeWorkExtendRouter[4]
                                }
                            } else {
                                if (state.arrangeWorkExtend.eventType == '') {
                                    if (this.isCreateUser) {
                                        return arrangeWorkExtendRouter[5]
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return false
        }
    },
    actions: {
        async getSeatUnit() {
            const res = await getSeatUnitApi({ pageIndex: 1, pageSize: 999 })
            if (res.code == 200) {
                this.selectList.seatList = res.data.list || []
            }
        },
        async getEnetOrgTree() {
            const res = await getEnetOrgTreeApi({})
            if (res.code == 200) {
                this.selectList.EnetOrgTree = res.data || []
            }
        },
        async getArrangeWorkDetail() {
            const res = await getArrangeWorkDetailApi({ id: this.id })
            if (res.code == 200) {
                this.details = res.data
                this.arrangeWorkExtendList = res.data.arrangeWorkExtendList || []
                this.arrangeWorkExtend = res.data.arrangeWorkExtendList[0]
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                state: null,
                presenter: '',
                seat: '',
                workType: 1,
                startTime: null,
                stopTime: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useAssignWorkStore
