import { getAirlineAcregApi } from 'mocp/api/electronicBill'
import { formData } from './add.compositions'

export const changeAcreg = async (acreg) => {
    if (!acreg) return
    const res = await getAirlineAcregApi({ acreg }, { loading: true })
    if (res.code == 200) {
        if (res.data?.aircaraftoperator) {
            formData.aircaraftoperator = res.data.aircaraftoperator
        }
        if (res.data?.actype) {
            formData.model = res.data.actype
        }
        if (res.data?.flightNo) {
            formData.flightNo = res.data.flightNo
        }
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addQtgj = () => {
    formData.qtgj.push({
        jh: '',
        ts: undefined
    })
}
export const delQtgj = (index) => {
    formData.qtgj.splice(index, 1)
}
