import { getAircraftNumbersApi, getBasicParamsListApi } from 'mocp/api/base'
import { defineStore } from 'pinia'

const useBaseStore = defineStore('base', {
    state: () => {
        return {
            isloading: false, //是否加载
            selectList: {
                deviceNumSelect: [] //机号
            },
            allBasicParams: {}
        }
    },
    getters: {},
    actions: {
        async initSysData() {
            if (this.isloading) return
            uni.showLoading({
                title: '正在加载系统所有基本参数中，请稍后！',
                mask: true
            })
            try {
                await this.getAircraftNumbers()
                await this.getBasicParamsList()
                uni.hideLoading()
                this.isloading = true
            } catch (error) {
                uni.hideLoading()
            }
        },
        async getAircraftNumbers() {
            const res = await getAircraftNumbersApi({})
            if (res.code == 200) {
                this.selectList.deviceNumSelect = res.data
            }
        },
        async getBasicParamsList() {
            const res = await getBasicParamsListApi({})
            if (res.code == 200) {
                this.allBasicParams = res.data.reduce((q, w) => {
                    if (!q[w.paramType]) {
                        q[w.paramType] = []
                    }
                    q[w.paramType].push(w)
                    return q
                }, {})
            }
        },
        getParamsByType(paramType) {
            return this.allBasicParams[paramType]
                ?.filter((item) => item.isDel == 0)
                ?.map((item) => {
                    return { label: item.paramName, value: item.paramCode }
                })
        },
        getParamNameByValue(paramType, paramName) {
            return this.getParamsByType(paramType).find((item) => item.value == paramName)?.label || ''
        }
    },
    // 配置持久化
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useBaseStore
