import { defineStore } from 'pinia'

const useInforDisclosureStore = defineStore('inforDisclosure', {
    state: () => {
        return {
            searchData: {
                state: 1,
                machineNumber: '',
                planeModel: '',
                aviation: '',
                terminal: '',
                startTime: '',
                guarantee: '',
                rlease_state: '',
                function_Info: '',
                failure_state: '',
                professional: ''
            },
            details: undefined
        }
    },
    getters: {},
    actions: {
        resetForm() {
            this.searchData = {
                state: 1,
                machineNumber: '',
                planeModel: '',
                aviation: '',
                terminal: '',
                startTime: '',
                guarantee: '',
                rlease_state: '',
                function_Info: '',
                failure_state: '',
                professional: ''
            }
        },
        setState(...args) {
            this.$patch({[args[0]]: args[1]})
        }
    },
    // 配置持久化
    // persist: false
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useInforDisclosureStore
