import { ref, computed } from 'vue'

const dayForMilliseconds = 24 * 3600 * 1000

export function decideTimeRange(inputNum: number) {
    const d = new Date(inputNum)
    d.setHours(5, 0, 0, 0)
    return {
        startT: d.getTime(),
        stopT: d.getTime() + dayForMilliseconds
    }
}

export const listTab = ref([
    {label: '航班号', keyValue: 'flightNo', flex: 3, selected: true},
    {label: '机号', keyValue: 'ac', flex: 2, selected: true},
    {label: '机型', keyValue: 'acTypeGc', flex: 2, selected: true},
    {label: '机位', keyValue: 'parkPlace', flex: 2, selected: false},
    {label: '出发地', keyValue: 'place', flex: 2, selected: true},//place
    {label: '预/实', keyValue: 'time', flex: 2, selected: true},//etaChn ataChn : etdChn atdChn time
    {label: '计划', keyValue: 'staChn', flex: 2, selected: true},//staChn schTime
    {label: '特殊任务', keyValue: 'isSpecialTask', flex: 2, selected: false},
    {label: '状态', keyValue: 'status', flex: 2, selected: true}
])

export const listScreen = [
    {name: '进港', value: 0},
    {name: '出港', value: 1},
    {name: '无航班', value: 2}
]

export const fightListTime = ['etdChn', 'atdChn', 'etaChn', 'ataChn']
export const fightListPlanTime = ['staChn', 'schTime']
export const finishedStatus = ['ARR', 'NDR', 'ATA']
export const depStatus = ['DEP']

