// 通用提示
export const showToast = (msg, options) => {
    uni.showToast({
        title: msg || '操作失败',
        icon: 'none',
        duration: 2000,
        ...options
    })
}
// 消息提示
export const toast = (message) => {
    uni.$emit('useMessage', { type: 'default', message })
}
// 错误消息
export const error = (message) => {
    uni.$emit('useMessage', { type: 'error', message })
}
// 成功消息
export const success = (message) => {
    uni.$emit('useMessage', { type: 'success', message })
}
// 警告消息
export const warning = (message) => {
    uni.$emit('useMessage', { type: 'warning', message })
}
