import { defineStore } from 'pinia'
import useUserStore from 'mocp/store/user'
import { decideTimeRange, listTab, listScreen } from 'mocp/utils/getFlightList'

const { startT, stopT } = decideTimeRange(new Date().getTime())
const useFlightSupportStore = defineStore('flightSupport', {
    state: () => {
        return {
            searchData: {
                isOut: 0, //0-进港  1-出港  2-无航班
                startT,
                stopT,
                isInbound: 1
            },
            screenData: {
                terminal: '', //航站
                acType: '', //机型
                acOwn: '', //航司
                ac: '', //机号
                flightNo: '' //航班号
            },
            listTab,
            listScreen,
            listScreenCurrent: 1,
            details: undefined,
            filterDetailsList: [],
            filterDetailsCurrentIndex: 0
        }
    },
    getters: {
        getSearchData(state) {
            const userStore = useUserStore()
            return { ...state.searchData, ...state.screenData, terminal: userStore.userInfo?.terminal || 'WUH' }
        },
        getSelectedList(state) {
            return state.listTab.filter((item) => item.selected)
        },
        getTerminal() {
            const userStore = useUserStore()
            return userStore.userInfo?.terminal || 'WUH'
        },
        getDetailsCurrentMsg(state) {
            return state.filterDetailsList[state.filterDetailsCurrentIndex]
        }
    },
    actions: {
        setTerminal() {
            this.screenData.terminal = this.getTerminal
        },
        resetScreenForm() {
            const userStore = useUserStore()
            this.screenData = {
                terminal: this.getTerminal,
                acType: '',
                acOwn: '',
                ac: '',
                flightNo: ''
            }
        },
        setStateScreen(state) {
            this.screenData = {
                ...state,
                terminal: this.getTerminal
            }
        },
        // 设置列表tab筛选数据
        setListTabSelected(args) {
            this.listTab = this.listTab.map((item) => {
                const that = args.find((args) => args == item.label)
                return {
                    ...item,
                    selected: !!that
                }
            })
        }
    },
    // 配置持久化
    persist: false
})

export default useFlightSupportStore
