import { getUnplanApplyApi } from 'mocp/api/unplanApply'
import { defineStore } from 'pinia'

const useUnplanApplyStore = defineStore('unplanApply', {
    state: () => {
        return {
            searchData: {
                applyStatus: '',
                packageNo: '',
                exemptStatus: null,
                sourceType: '',
                checkLevel: null,
                acType: '',
                airline: '',
                startTime: null,
                startTimeEnd: null,
                applyTimeStart: null,
                applyTimeEnd: null
            },
            id: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getDetails() {
            this.details = undefined
            const res = await getUnplanApplyApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                applyStatus: '',
                packageNo: '',
                exemptStatus: null,
                sourceType: '',
                checkLevel: null,
                acType: '',
                airline: '',
                startTime: null,
                startTimeEnd: null,
                applyTimeStart: null,
                applyTimeEnd: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useUnplanApplyStore
