import { getUnplanWarningApi } from 'mocp/api/unplanWarning'
import { defineStore } from 'pinia'

const useUnplanWarningStore = defineStore('unplanWarning', {
    state: () => {
        return {
            searchData: {
                applyStatus: '',
                packageNo: '',
                sourceType: '',
                checkLevel: null,
                acType: '',
                airline: '',
                startTime: null,
                startTimeEnd: null,
                applyTimeStart: null,
                applyTimeEnd: null
            },
            id: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getDetails() {
            this.details = undefined
            const res = await getUnplanWarningApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                applyStatus: '',
                packageNo: '',
                sourceType: '',
                checkLevel: null,
                acType: '',
                airline: '',
                startTime: null,
                startTimeEnd: null,
                applyTimeStart: null,
                applyTimeEnd: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useUnplanWarningStore
