import { reactive, ref } from 'vue'

export const formData = reactive({
    source: '',
    terminalCode: '',
    repairUnit: '',
    personLiable: '',
    machineNumber: '',
    model: '',
    aviation: '',
    eventDescription: '',
    problemPoints: '',
    category: '',
    pointsDeduction: null,
    occurrenceTime: null,
    surveyUnit: '',
    eventProperty: '',
    remake: '',
    survey: '',
    surveyAtta: '',
    surveyAttaFileVoList: [],
    surveyTimeLimit: null,
    surveyFeedback: '',
    correctiveComplete: '',
    correctiveAtta: '',
    correctiveAttaFileVoList: [],
    correctiveTimeLimit: null,
    correctiveComplete: '',
    correctiveMeasures: '',
    delay: ''
})
export const rules = reactive({
    terminalCode: [
        {
            required: true,
            message: '请选择航站',
            trigger: ['blur', 'change']
        }
    ],
    repairUnitId: [
        {
            required: true,
            message: '请选择责任单位',
            trigger: ['blur', 'change']
        }
    ],
    source: [
        {
            required: true,
            message: '请选择事件来源',
            trigger: ['blur', 'change']
        }
    ],
    personLiable: [
        {
            required: true,
            message: '请填写责任人',
            trigger: ['blur', 'change']
        }
    ],
    machineNumber: [
        {
            required: true,
            message: '请选择机号',
            trigger: ['blur', 'change']
        }
    ],
    eventDescription: [
        {
            required: true,
            message: '请选择事件描述',
            trigger: ['blur', 'change']
        }
    ],
    problemPoints: [
        {
            required: true,
            message: '请填写问题点',
            trigger: ['blur', 'change']
        }
    ],
    category: [
        {
            required: true,
            message: '请选择类别',
            trigger: ['blur', 'change']
        }
    ],
    pointsDeduction: [
        {
            type: 'number',
            required: true,
            message: '请填写扣分情况(请填写负数，例如-10)',
            trigger: ['blur', 'change']
        }
    ],
    occurrenceTime: [
        {
            type: 'number',
            required: true,
            message: '请选择接报日期',
            trigger: ['blur', 'change']
        }
    ],
    surveyUnit: [
        {
            required: true,
            message: '请填写调查单位',
            trigger: ['blur', 'change']
        }
    ],
    survey: [
        {
            required: true,
            message: '请选择调查反馈',
            trigger: ['blur', 'change']
        }
    ],
    correctiveComplete: [
        {
            required: true,
            message: '请选择完成整改',
            trigger: ['blur', 'change']
        }
    ],
    eventProperty: [
        {
            required: true,
            message: '请选择事件性质',
            trigger: ['blur', 'change']
        }
    ],
    delay: [
        {
            required: true,
            message: '请选择是否延误',
            trigger: ['blur', 'change']
        }
    ]
})
export const formRef = ref()
export const surveyAttaFileVoList = ref([])
export const correctiveAttaFileVoList = ref([])
