import { defineStore } from 'pinia'
import {
    getAogConstructionApi,
    getAogDisposalPlanApi,
    getAogMaterialListApi,
    getAogOtherSupApi,
    getAogSupBaseApi,
    getWorkBenchListApi
} from 'mocp/api/aog'

const useAogStore = defineStore('aog', {
    state: () => {
        return {
            searchData: {
                state: '1',
                machineNumber: '',
                model: '',
                aviation: '',
                terminal: '',
                major: null,
                aogLevel: null,
                happenDateStart: null,
                happenDateEnd: null,
                aogStartTimeStart: null,
                aogStartTimeEnd: null,
                happenAddr: '',
                faultDesc: ''
            },
            details: undefined,
            workBench: undefined, //工作台详情
            disposalPlan: [], //处置方案

            avData: [], //航材
            toolData: [], //工具
            materialIndex: -1, //航材(或工具)详情的下标
            materialType: 1, //1-航材,2-工具

            pData: [], //人员
            pIndex: -1, //人员详情的下标

            bbData: [], //施工情况
            bbIndex: -1, //施工情况详情的下标

            oData: undefined, //其他特殊保障
            oIndex: -1 //其他特殊保障的下标
        }
    },
    getters: {
        /**
         *
         * @param {*} state
         * @returns 获取对应状态
         */
        getAvStatus(state) {
            let avStatus = 3
            if (state.avData && state.avData.length) {
                if (state.avData.every((a) => a.actualArrivalTime)) {
                    avStatus = 2
                } else if (state.avData.some((a) => a.actualArrivalTime)) {
                    avStatus = 1
                } else {
                    avStatus = 0
                }
            }
            return avStatus
        },
        getToolStatus(state) {
            let toolStatus = 3
            if (state.toolData && state.toolData.length) {
                if (state.toolData.every((a) => a.actualArrivalTime)) {
                    toolStatus = 2
                } else if (state.toolData.some((a) => a.actualArrivalTime)) {
                    toolStatus = 1
                } else {
                    toolStatus = 0
                }
            }
            return toolStatus
        },
        getPersonnelStatus(state) {
            let personnelStatus = 3
            if (state.pData && state.pData.length) {
                if (state.pData.every((a) => a.realityCompleteTime)) {
                    personnelStatus = 2
                } else if (state.pData.some((a) => a.realityCompleteTime)) {
                    personnelStatus = 1
                } else {
                    personnelStatus = 0
                }
            }
            return personnelStatus
        },
        getBbStatus(state) {
            let bbStatus = 3
            if (state.bbData && state.bbData.length) {
                if (state.bbData.every((a) => a.realityCompleteTime)) {
                    bbStatus = 2
                } else if (state.bbData.some((a) => a.realityCompleteTime)) {
                    bbStatus = 1
                } else {
                    bbStatus = 0
                }
            }
            return bbStatus
        },
        getOtherStatus(state) {
            let otherStatus = 3
            if (state.oData.every((a) => a === null || !a.id)) {
                otherStatus = 3
            } else {
                if (state.oData.every((a) => a.realityCompleteTime)) {
                    otherStatus = 2
                } else if (state.oData.some((a) => a.realityCompleteTime)) {
                    otherStatus = 1
                } else {
                    otherStatus = 0
                }
            }
            return otherStatus
        },
        /**
         *
         * @param {*} state
         * @returns 获取对应数据
         */
        getMaterialData(state) {
            if (state.materialType == 1) {
                return state.avData
            } else {
                return state.toolData
            }
        },
        getMaterialDetails(state) {
            if (state.materialIndex >= 0) {
                if (state.materialType == 1) {
                    return state.avData[state.materialIndex]
                } else {
                    return state.toolData[state.materialIndex]
                }
            } else {
                return undefined
            }
        },
        getPDetails(state) {
            if (state.pIndex >= 0) {
                return state.pData[state.pIndex]
            } else {
                return undefined
            }
        },
        getBbDetails(state) {
            if (state.bbIndex >= 0) {
                return state.bbData[state.bbIndex]
            } else {
                return undefined
            }
        },
        getODetails(state) {
            if (state.oIndex >= 0) {
                return state.oData[state.oIndex]
            } else {
                return undefined
            }
        }
    },
    actions: {
        async getWorkBenchList() {
            const res = await getWorkBenchListApi({ workbenchId: this.details?.workbenchId })
            if (res.code == 200) {
                this.workBench = res.data?.list[0]
            }
        },
        async getAogDisposalPlan() {
            const res = await getAogDisposalPlanApi({ workbenchId: this.details?.workbenchId })
            if (res.code == 200) {
                this.disposalPlan = res.data
            } else {
                this.disposalPlan = []
            }
        },
        async getAogMaterialList(materialType) {
            const res = await getAogMaterialListApi({ workbenchId: this.details?.workbenchId, materialType })
            if (res.code == 200 && res.data.materialMap) {
                if (materialType == 1) {
                    this.avData = Object.values(res.data.materialMap).flat()
                } else if (materialType == 2) {
                    this.toolData = Object.values(res.data.materialMap).flat()
                }
            } else {
                this.avData = []
                this.toolData = []
            }
        },
        async getAogSupBase() {
            const res = await getAogSupBaseApi({ workbenchId: this.details?.workbenchId })
            if (res.code == 200 && res.data.mapList) {
                this.pData = Object.values(res.data.mapList).flat()
            } else {
                this.pData = []
            }
        },
        async getAogConstruction() {
            const res = await getAogConstructionApi({ workbenchId: this.details?.workbenchId })
            if (res.code == 200) {
                this.bbData = res.data.constructionList || []
            }
        },
        async getAogOtherSup() {
            const res = await getAogOtherSupApi({ workbenchId: this.details?.workbenchId })
            if (res.code == 200 && res.data) {
                this.oData = Object.entries(res.data).reduce((q, w) => {
                    if (w[0] !== 'otherData') {
                        q.push({ ...w[1], key: w[0] })
                    }
                    return q
                }, [])
            } else {
                this.oData = []
            }
        },
        resetForm() {
            this.searchData = {
                state: '1',
                machineNumber: '',
                model: '',
                aviation: '',
                terminal: '',
                major: null,
                aogLevel: null,
                happenDateStart: null,
                happenDateEnd: null,
                aogStartTimeStart: null,
                aogStartTimeEnd: null,
                happenAddr: '',
                faultDesc: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useAogStore
