import { defineStore } from 'pinia'
import Day from 'mocp/utils/dayjs'

const currentTime = Day(new Date())
const dateEnd = currentTime.format('YYYY-MM-DD')

const useInforDisclosureStore = defineStore('inforDisclosure', {
    state: () => {
        return {
            searchData: {
                machineNumber: '',
                planeModel: '',
                aviation: '',
                terminal: '',
                startTime: '',//填报日期-当前日期
                guarantee: '',//保障阶段0 1 2
                rlease_state: '',//完成状态0123
                function_Info: '',//运行阶段012
                failure_state: '',//故障状态
                professional: ''//专业类别
            },
            details: undefined
        }
    },
    getters: {},
    actions: {
        resetForm() {
            this.searchData = {
                machineNumber: '',
                planeModel: '',
                aviation: '',
                terminal: '',
                startTime: '',
                guarantee: '',
                rlease_state: '',
                function_Info: '',
                failure_state: '',
                professional: ''
            }
        },
        setState(...args) {
            this.$patch({[args[0]]: args[1]})
        }
    },
    // 配置持久化
    persist: false
})
export default useInforDisclosureStore
