import { getRqmDetailsApi, getRqmOptionsApi } from '@/api/appraisal-record'
import { defineStore } from 'pinia'

const useAppraisalRecordStore = defineStore('appraisalRecord', {
    state: () => {
        return {
            selectList: {
                appraisee: [],
                department: [],
                examineType: []
            },
            id: '',
            details: undefined
        }
    },
    getters: {
        getFileList(state) {
            return state.details?.file || []
        }
    },
    actions: {
        async getRqmOptions() {
            const res = await getRqmOptionsApi({})
            if (res.code == 200) {
                this.selectList.appraisee = res.data.appraisee || []
                this.selectList.department = res.data.department || []
                this.selectList.examineType = res.data.examineType || []
            }
        },
        async getRqmDetails() {
            const res = await getRqmDetailsApi({ id: this.id }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
                this.details.file = JSON.parse(res.data.file)
                this.details.eventTime = String(res.data.eventTime)
            } else {
                uni.$message.showToast(res.message)
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useAppraisalRecordStore
