import { getAircraftNumbersApi } from '@/api/base'
import { defineStore } from 'pinia'

const useBaseStore = defineStore('base', {
    state: () => {
        return {
            selectList: {
                deviceNumSelect: [] //机号
            }
        }
    },
    getters: {},
    actions: {
        async getAircraftNumbers() {
            const res = await getAircraftNumbersApi({})
            if (res.code == 200) {
                this.selectList.deviceNumSelect = res.data
            }
        }
    },
    // 配置持久化
    persist: false
})
export default useBaseStore
