import { defineStore } from 'pinia'
import { cloneDeep } from 'lodash'
const menuList = [
    { id: 1, name: '信息通报', icon: 'xxtb', group: '技术支援', count: 12 },
    { id: 2, name: '机队状态', icon: 'jdzt', group: '技术支援', count: 0 },
    { id: 3, name: '支援申请', icon: 'zysq', group: '技术支援', count: 0 },
    { id: 4, name: '工作指令', icon: 'gzzl', group: '技术支援', count: 0 },
    { id: 5, name: '技术评估', icon: 'jspg', group: '技术支援', count: 0 },
    { id: 6, name: '运行调查', icon: 'yxdc', group: '维修控制', count: 0 },
    { id: 7, name: '运行决策', icon: 'yxjc', group: '维修控制', count: 0 },
    { id: 8, name: '布置工作', icon: 'bzgz', group: '维修控制', count: 0 },
    { id: 9, name: '航站管理', icon: 'hzgl', group: '航站管理', count: 0 },
    { id: 10, name: '协议单位', icon: 'xydw', group: '航站管理', count: 0 },
    { id: 11, name: '不正常事件', icon: 'bzcsj', group: '运行品质', count: 0 },
    { id: 12, name: '考核记录', icon: 'khjl', group: '运行品质', count: 0, url: '/pages/panel/appraisal-record/list' },
    { id: 13, name: 'AOG任务', icon: 'AOG', group: '运行品质', count: 0 },
    { id: 14, name: 'MCO', icon: 'MCO', group: '运行品质', count: 0 },
    { id: 15, name: '航班保障', icon: 'hbbz', group: '运行品质', count: 0 }
]
const useUserStore = defineStore('user', {
    state: () => {
        return {
            token: '',
            userInfo: undefined, //用户信息
            menuList: cloneDeep(menuList), //全部菜单
            allMenuItem: { id: 999, name: '全部菜单', icon: 'all', group: '', count: 0 },
            allHomeMenuList: [] //所有登录用户的首页菜单信息
        }
    },
    getters: {
        //获取分组菜单
        getGroupMenuList(state) {
            return state.menuList.reduce((groups, item) => {
                // 如果该组不存在，则创建一个新组
                if (!groups[item.group]) {
                    groups[item.group] = []
                }
                // 将当前项添加到对应的组中
                groups[item.group].push(item)
                return groups
            }, {})
        },
        //获取当前登录用户的首页菜单
        getHomeMenuList(state) {
            return state.allHomeMenuList.find((item) => item.userId == state.userInfo?.id)?.homeMenuList || state.menuList
        }
    },
    actions: {
        //用户登录
        setUserInfo(data) {
            this.token = data.token
            this.userInfo = data
            //加入用户首页菜单信息
            if (!this.allHomeMenuList.find((item) => item.userId == this.userInfo.id)) {
                this.allHomeMenuList.push({
                    userId: this.userInfo.id,
                    homeMenuList: this.menuList
                })
            }
            //跳转工作台
            uni.switchTab({ url: '/pages/panel/index' })
        },
        //退出登录
        handleLogOut() {
            this.token = ''
            this.userInfo = undefined
            //返回登录页面
            uni.redirectTo({ url: '/pages/login/index' })
        },
        //修改用户首页菜单
        changeHomeMenuList(menuList) {
            const index = this.allHomeMenuList.findIndex((item) => item.userId == this.userInfo.id)
            this.allHomeMenuList[index].homeMenuList = menuList
        }
    },
    // 配置持久化
    persist: {
        // 调整为兼容多端的API
        storage: {
            setItem(key, value) {
                uni.setStorageSync(key, value)
            },
            getItem(key) {
                return uni.getStorageSync(key)
            }
        }
    }
})
export default useUserStore
