// utils/tool.js
import Day from './dayjs'

/**
 * 时间戳格式化
 * 1715072168340 => 2024-05-07 16:56:08
 */
export const timeStampFormat = (timeStamp, opt) => {
    if (!timeStamp || timeStamp == -1 || timeStamp == '-1') {
        return ''
    }
    timeStamp = parseInt(String(timeStamp))
    const format = opt?.format || 'YYYY-MM-DD HH:mm:ss'
    return Day(timeStamp).format(format)
}
