import { getMeDataApi } from 'mocp/api/mechanicalAbnormalEvents'
import { defineStore } from 'pinia'

const useMechanicalAbnormalEventsStore = defineStore('mechanicalAbnormalEvents', {
    state: () => {
        return {
            searchData: {
                isOpen: 1,
                ac: '',
                acType: '',
                acOwn: '',
                eventType: 0,
                runEvent: null,
                happenStn: '',
                delayNature: '',
                delayProperty: '',
                startTime: null,
                stopTime: null,
                flightNo: '',
                msg: ''
            },
            workbenchId: '',
            details: undefined
        }
    },
    getters: {},
    actions: {
        async getMeData() {
            const res = await getMeDataApi({ workbenchId: this.workbenchId }, { loading: true })
            if (res.code == 200) {
                this.details = res.data
            } else {
                uni.$mocpMessage.error(res.message)
            }
        },
        resetForm() {
            this.searchData = {
                isOpen: 1,
                ac: '',
                acType: '',
                acOwn: '',
                eventType: 0,
                runEvent: null,
                happenStn: '',
                delayNature: '',
                delayProperty: '',
                startTime: null,
                stopTime: null,
                flightNo: '',
                msg: ''
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMechanicalAbnormalEventsStore
