import { updateDutyLogApi } from 'mocp/api/dutyLog'
import { formData, formRef, showAction } from './edit.compositions'

export const resetData = () => {
    Object.assign(formData, {
        id: '',
        dutyManagerUname: '',
        dutyManagerUid: '',
        successorManagerUname: '',
        successorManagerUid: '',
        monitorLeaderUname: '',
        monitorLeaderUid: '',
        reportWork: '',
        importantFlight: '',
        meetingArrangementWork: '',
        handoverWork: '',
        dutyDate: undefined,
        dutyArea: ''
    })
}

export const handleRightClick = async () => {
    await formRef.value?.validate()
    showAction.value = true
}

//提交表单
export const handleSubmit = async (statusStr) => {
    await formRef.value?.validate()
    const res = await updateDutyLogApi({ ...formData, statusStr }, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        uni.$mocpMessage.success(res.message)
        uni.$emit('dutyLogReload')
        uni.$emit('updateDutyLog')
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
