import { upload } from 'mocp/utils/http'
import { canvasImage } from './sign.compositions'
import { antiicingFile, antiicingFlag, deicingFile, deicingFlag, formData, showAntiicing, showDeicing } from './add.compositions'
import { addDeicingApi, updateDeicingApi } from 'mocp/api/electronicBill'
import Day from 'mocp/utils/dayjs'

export const handleSubmit = async () => {
    uni.showLoading({
        title: '保存中...',
        mask: true
    })
    try {
        if (!canvasImage.value.includes('https')) {
            await uploadFile()
        }
        if (formData.id > 0) {
            await updateDeicing()
        } else {
            await addDeicing()
        }
    } catch (error) {
        console.error(error)
    } finally {
        uni.hideLoading()
    }
}
export const uploadFile = async () => {
    const res = await upload({ url: '/resource/uploadFile', filePath: canvasImage.value, name: 'file' })
    if (res.code == 200) {
        formData.customerSignImg = res.data.fileUrl
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const addDeicing = async () => {
    const params = {
        ...formData
    }
    if (formData.deicingMix == 'Other') {
        params.deicingMix = formData.deicingMix1 + ':' + formData.deicingMix2
    }
    if (formData.antiicingMix == 'Other') {
        params.antiicingMix = formData.antiicingMix1 + ':' + formData.antiicingMix2
    }
    const res = await addDeicingApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$emit('deicingReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const updateDeicing = async () => {
    const params = {
        ...formData
    }
    if (formData.deicingMix == 'Other') {
        params.deicingMix = formData.deicingMix1 + ':' + formData.deicingMix2
    }
    if (formData.antiicingMix == 'Other') {
        params.antiicingMix = formData.antiicingMix1 + ':' + formData.antiicingMix2
    }
    const res = await updateDeicingApi(formData, { loading: true })
    if (res.code == 200) {
        uni.$emit('deicingReload')
        uni.$mocpJump.navigateBack(2)
        resetData()
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
export const resetData = () => {
    Object.assign(formData, {
        acreg: '',
        aircaraftoperator: '',
        antiicingCartNo1: '',
        antiicingCartNo2: '',
        antiicingCartNo3: '',
        antiicingCartNo4: '',
        antiicingDuration: '',
        antiicingEndTime: '',
        antiicingMix: '100:0',
        antiicingMix1: undefined,
        antiicingMix2: undefined,
        antiicingPersion1: '',
        antiicingPersion2: '',
        antiicingPersion3: '',
        antiicingPersion4: '',
        antiicingQuantity1: undefined,
        antiicingQuantity2: undefined,
        antiicingQuantity3: undefined,
        antiicingQuantity4: undefined,
        antiicingQuantityTotal: undefined,
        antiicingStartTime: '',
        antiicingType: '',
        antiicingUnit1: '',
        antiicingUnit2: '',
        antiicingUnit3: '',
        antiicingUnit4: '',

        antiicing2CartNo1: '',
        antiicing2CartNo2: '',
        antiicing2CartNo3: '',
        antiicing2CartNo4: '',
        antiicing2Duration: '',
        antiicing2EndTime: '',
        antiicing2Mix: '100:0',
        antiicing2Mix1: undefined,
        antiicing2Mix2: undefined,
        antiicing2Persion1: '',
        antiicing2Persion2: '',
        antiicing2Persion3: '',
        antiicing2Persion4: '',
        antiicing2Quantity1: undefined,
        antiicing2Quantity2: undefined,
        antiicing2Quantity3: undefined,
        antiicing2Quantity4: undefined,
        antiicing2QuantityTotal: undefined,
        antiicing2StartTime: '',
        antiicing2Type: '',
        antiicing2Unit1: '',
        antiicing2Unit2: '',
        antiicing2Unit3: '',
        antiicing2Unit4: '',

        customerSignImg: '',
        date: Day().valueOf(),
        deicingCartNo1: '',
        deicingCartNo2: '',
        deicingCartNo3: '',
        deicingCartNo4: '',
        deicingEndTime: '',
        deicingMix: '50:50',
        deicingMix1: undefined,
        deicingMix2: undefined,
        deicingPersion1: '',
        deicingPersion2: '',
        deicingPersion3: '',
        deicingPersion4: '',
        deicingQuantity1: undefined,
        deicingQuantity2: undefined,
        deicingQuantity3: undefined,
        deicingQuantity4: undefined,
        deicingQuantityTotal: undefined,
        deicingStartTime: '',
        deicingType: '',
        deicingUnit1: '',
        deicingUnit2: '',
        deicingUnit3: '',
        deicingUnit4: '',
        expectDeicing: '0',
        fixedPointDeicing: '0',
        flightNoIn: '',
        flightNoOut: '',
        id: undefined,
        legs: '',
        model: '',
        nickname: '',
        originalAircraftPositionDeicing: '0',
        station: '',
        username: '',
        guaranteeUnit: '',
        weatherToday: '',
        modelType: '',
        remark: '',
        deicingFile: '',
        deicingRemark: '',
        antiicingFile: '',
        antiicingRemark: '',
        antiicing2File: '',
        antiicing2Remark: ''
    })
    showDeicing.value = false
    showAntiicing.value = false
    deicingFlag.value = false
    antiicingFlag.value = false
    deicingFile.value = []
    antiicingFile.value = []
}
