import { changeExemptStatusApi, changeStatusApi } from 'mocp/api/unplanApply'
import { formData, formRef } from './details.compositions'

export const handleSelect = async (value, id) => {
    if (value !== '3') {
        await formRef.value?.validate()
    }
    const params = {
        id,
        applyStatus: value,
        examineReason: formData.examineReason
    }
    const res = await changeStatusApi(params, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        uni.$emit('unplanApplyReload')
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}

export const changeExemptStatus = async (id, status, callBack) => {
    const res = await changeExemptStatusApi({ id, status }, { loading: '修改中...' })
    if (res.code == 200) {
        uni.$mocpMessage.success(res.message)
        callBack()
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
