import { changeStatusApi } from 'mocp/api/unplanWarning'
import { formData, formRef } from './details.compositions'

export const handleSelect = async (value, id) => {
    if (value !== '3') {
        await formRef.value?.validate()
    }
    const params = {
        id,
        applyStatus: value,
        examineReason: formData.examineReason
    }
    const res = await changeStatusApi(params, { loading: true })
    if (res.code == 200) {
        uni.$mocpJump.navigateBack()
        uni.$emit('unplanWarningReload')
        uni.$mocpMessage.success(res.message)
    } else {
        uni.$mocpMessage.error(res.message)
    }
}
