import { defineStore } from 'pinia'
import useUserStore from 'mocp/store/user'
import { decideTimeRange, listTab, listScreen } from 'mocp/utils/getFlightList'
import Day from 'mocp/utils/dayjs'

const {startT, stopT} = decideTimeRange(new Date().getTime())

const useFlightSupportStore = defineStore('flightSupport', {
    state: () => {
        return {
            searchData: {
                isOut: 0,//0-进港  1-出港  2-无航班
                startT,
                stopT,
                isInbound: 1,

                ac: '',//机号
                flightNo: '',//航班号

                acOwns2: '',
                acTerminals1: '',
                acTypes2: '',
                acs1: ''
            },
            screenData: {
                terminal: 'WUH',//航站
                acType: '',//机型
                acOwn: ''//航司
            },
            listTab,
            listScreen,
            listScreenCurrent: 1,
            details: undefined,
            filterDetailsList: [],
            filterDetailsCurrentIndex: 0
        }
    },
    getters: {
        getSearchData (state) {
            const userStore = useUserStore()
            return {...state.searchData, ...state.screenData, terminal: userStore.userInfo?.terminal || 'WUH'}
        },
        getSelectedList (state) {
            return state.listTab.filter(item => item.selected)
        },
        getTerminal () {
            const userStore = useUserStore()
            return userStore.userInfo?.terminal || 'WUH'
        },
        getDetailsCurrentMsg (state) {
            return state.filterDetailsList[state.filterDetailsCurrentIndex]
        }
    },
    actions: {
        resetScreenForm () {
            const userStore = useUserStore()
            this.screenData = {
                terminal: userStore.userInfo?.terminal || 'WUH',
                acType: '',
                acOwn: ''
            }
        },
        setStateScreen (state) {
            const userStore = useUserStore()
            this.screenData = {
                terminal: state.terminal || userStore.userInfo?.terminal || 'WUH',
                acType: state.acType,
                acOwn: state.acOwn
            }
        },
        // 设置列表tab筛选数据
        setListTabSelected (args) {
            this.listTab = this.listTab.map(item => {
                const that = args.find(args => args == item.label)
                return {
                    ...item,
                    selected: !!that
                }
            })
        }
    },
    // 配置持久化
    persist: false
    /*persist: {
        // 调整为兼容多端的API
        storage: {
            setItem (key, value) {
                uni.setStorageSync(key, value)
            },
            getItem (key) {
                return uni.getStorageSync(key)
            }
        }
    }*/
})

export default useFlightSupportStore
