import { defineStore } from 'pinia'
import useUserStore from 'mocp/store/user'
import { getArrangeWorkListForAppApi, getDecisiongetDecisionToDoApi, getRqmListForMobileApi, getTechnicalEvaluationToDoApi } from 'mocp/api/my-toDo'

const useMyToDoStore = defineStore('myToDo', {
    state: () => {
        return {
            assignWorkNum: 0, //布置工作
            appraisalRecordNum: 0, //考核记录
            moveDecisionNum: 0, //运行决策
            technologyEvaluationNum: 0 //技术评估
        }
    },
    getters: {
        getTotal(state) {
            const total = state.assignWorkNum + state.appraisalRecordNum + state.moveDecisionNum + state.technologyEvaluationNum
            if (total > 0) {
                if (total > 99) {
                    return '99+'
                } else {
                    return total
                }
            } else {
                return '-'
            }
        },
        getAssignWorkNum(state) {
            if (state.assignWorkNum > 0) {
                if (state.assignWorkNum > 99) {
                    return '99+'
                } else {
                    return state.assignWorkNum
                }
            } else {
                return '暂无待办'
            }
        },
        getAppraisalRecordNum(state) {
            if (state.appraisalRecordNum > 0) {
                if (state.appraisalRecordNum > 99) {
                    return '99+'
                } else {
                    return state.appraisalRecordNum
                }
            } else {
                return '暂无待办'
            }
        },
        getMoveDecisionNum(state) {
            if (state.moveDecisionNum > 0) {
                if (state.moveDecisionNum > 99) {
                    return '99+'
                } else {
                    return state.moveDecisionNum
                }
            } else {
                return '暂无待办'
            }
        },
        getTechnologyEvaluationNum(state) {
            if (state.technologyEvaluationNum > 0) {
                if (state.technologyEvaluationNum > 99) {
                    return '99+'
                } else {
                    return state.technologyEvaluationNum
                }
            } else {
                return '暂无待办'
            }
        }
    },
    actions: {
        async getArrangeWorkListForApp() {
            const userStore = useUserStore()
            const res = await getArrangeWorkListForAppApi({ pageIndex: 1, pageSize: 10, userId: userStore.userInfo?.id })
            if (res.code == 200) {
                this.assignWorkNum = parseInt(res.data.total) || 0
            }
        },
        async getRqmListForMobile() {
            const userStore = useUserStore()
            const res = await getRqmListForMobileApi({ pageIndex: 1, pageSize: 10, userId: userStore.userInfo?.id })
            if (res.code == 200) {
                this.appraisalRecordNum = parseInt(res.total) || 0
            }
        },
        async getDecisiongetDecisionToDo() {
            const res = await getDecisiongetDecisionToDoApi({ pageIndex: 1, pageSize: 10 })
            if (res.code == 200) {
                this.moveDecisionNum = parseInt(res.data.total) || 0
            }
        },
        async getTechnicalEvaluationToDo() {
            const res = await getTechnicalEvaluationToDoApi({ pageIndex: 1, pageSize: 10 })
            if (res.code == 200) {
                this.technologyEvaluationNum = parseInt(res.data.total) || 0
            }
        },
        async initData() {
            await Promise.all([
                (this.getArrangeWorkListForApp(), this.getRqmListForMobile(), this.getDecisiongetDecisionToDo(), this.getTechnicalEvaluationToDo())
            ])
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useMyToDoStore
