import { createSSRApp } from 'vue'
import App from './App.vue'
import pinia from 'mocp/store'
import uviewPlus, { setConfig } from 'uview-plus'
import * as message from 'mocp/utils/message'
import * as tool from 'mocp/utils/tool'
import * as jump from 'mocp/utils/jump'

//mocp消息提示
uni.$mocpMessage = message
//mocp工具方法
uni.$mocpTool = tool
//mocp页面跳转
uni.$mocpJump = jump
export function createApp() {
    const app = createSSRApp(App)
    app.use(pinia)
    app.use(uviewPlus)
    setConfig({
        props: {
            checkbox: {
                activeColor: '#165dff',
                labelColor: '#1D2129',
                labelSize: 16
            },
            checkboxGroup: {
                activeColor: '#165dff',
                labelColor: '#1D2129',
                labelSize: 16
            },
            radio: {
                activeColor: '#165dff',
                labelColor: '#1D2129',
                labelSize: 16
            },
            radioGroup: {
                activeColor: '#165dff',
                labelColor: '#1D2129',
                labelSize: 16
            },
            cell: {
                titleStyle: {
                    color: '#1D2129'
                }
            }
        }
    })
    return {
        app
    }
}
