import { defineStore } from 'pinia'

const useInformationDisclosureStore = defineStore('informationDisclosure', {
    state: () => {
        return {
            searchData: {
                state: null,
                presenter: '',
                seat: '',
                workType: 1,
                startTime: null,
                stopTime: null
            },
            details: undefined
        }
    },
    getters: {},
    actions: {
        resetForm() {
            this.searchData = {
                state: null,
                presenter: '',
                seat: '',
                workType: 1,
                startTime: null,
                stopTime: null
            }
        },
        setState(...args) {
            this.$patch({ [args[0]]: args[1] })
        }
    },
    // 配置持久化
    persist: false
})
export default useInformationDisclosureStore
